// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model



/**
 * Advanced event selectors let you create fine-grained selectors for the following CloudTrail event record ﬁelds. They help you control costs by logging only those events that are important to you. For more information about advanced event selectors, see [Logging data events for trails](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
 * + `readOnly`
 * + `eventSource`
 * + `eventName`
 * + `eventCategory`
 * + `resources.type`
 * + `resources.ARN`
 *
 * You cannot apply both event selectors and advanced event selectors to a trail.
 */
class AdvancedEventSelector private constructor(builder: Builder) {
    /**
     * Contains all selector statements in an advanced event selector.
     */
    val fieldSelectors: List<AdvancedFieldSelector>? = builder.fieldSelectors
    /**
     * An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".
     */
    val name: kotlin.String? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.AdvancedEventSelector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdvancedEventSelector(")
        append("fieldSelectors=$fieldSelectors,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldSelectors?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdvancedEventSelector

        if (fieldSelectors != other.fieldSelectors) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.AdvancedEventSelector = Builder(this).apply(block).build()

    class Builder {
        /**
         * Contains all selector statements in an advanced event selector.
         */
        var fieldSelectors: List<AdvancedFieldSelector>? = null
        /**
         * An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".
         */
        var name: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.AdvancedEventSelector) : this() {
            this.fieldSelectors = x.fieldSelectors
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.AdvancedEventSelector = AdvancedEventSelector(this)
    }
}
