// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.cloudtrail.model.*
import aws.sdk.kotlin.services.cloudtrail.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "CloudTrail"
const val ServiceApiVersion: String = "2013-11-01"
const val SdkVersion: String = "0.16.7-beta"

internal class DefaultCloudTrailClient(override val config: CloudTrailClient.Config) : CloudTrailClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds one or more tags to a trail or event data store, up to a limit of 50. Overwrites an existing tag's value when a new value is specified for an existing tag key. Tag key names must be unique for a trail; you cannot have two keys with the same name but different values. If you specify a key without a value, the tag will be created with the specified key and a value of null. You can tag a trail or event data store that applies to all Amazon Web Services Regions only from the Region in which the trail or event data store was created (also known as its home region).
     */
    override suspend fun addTags(input: AddTagsRequest): AddTagsResponse {
        val op = SdkHttpOperation.build<AddTagsRequest, AddTagsResponse> {
            serializer = AddTagsOperationSerializer()
            deserializer = AddTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a query if the query is not in a terminated state, such as `CANCELLED`, `FAILED`, `TIMED_OUT`, or `FINISHED`. You must specify an ARN value for `EventDataStore`. The ID of the query that you want to cancel is also required. When you run `CancelQuery`, the query status might show as `CANCELLED` even if the operation is not yet finished.
     */
    override suspend fun cancelQuery(input: CancelQueryRequest): CancelQueryResponse {
        val op = SdkHttpOperation.build<CancelQueryRequest, CancelQueryResponse> {
            serializer = CancelQueryOperationSerializer()
            deserializer = CancelQueryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelQuery"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new event data store.
     */
    override suspend fun createEventDataStore(input: CreateEventDataStoreRequest): CreateEventDataStoreResponse {
        val op = SdkHttpOperation.build<CreateEventDataStoreRequest, CreateEventDataStoreResponse> {
            serializer = CreateEventDataStoreOperationSerializer()
            deserializer = CreateEventDataStoreOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEventDataStore"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
     */
    override suspend fun createTrail(input: CreateTrailRequest): CreateTrailResponse {
        val op = SdkHttpOperation.build<CreateTrailRequest, CreateTrailResponse> {
            serializer = CreateTrailOperationSerializer()
            deserializer = CreateTrailOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTrail"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables the event data store specified by `EventDataStore`, which accepts an event data store ARN. After you run `DeleteEventDataStore`, the event data store enters a `PENDING_DELETION` state, and is automatically deleted after a wait period of seven days. `TerminationProtectionEnabled` must be set to `False` on the event data store; this operation cannot work if `TerminationProtectionEnabled` is `True`.
     *
     * After you run `DeleteEventDataStore` on an event data store, you cannot run `ListQueries`, `DescribeQuery`, or `GetQueryResults` on queries that are using an event data store in a `PENDING_DELETION` state. An event data store in the `PENDING_DELETION` state does not incur costs.
     */
    override suspend fun deleteEventDataStore(input: DeleteEventDataStoreRequest): DeleteEventDataStoreResponse {
        val op = SdkHttpOperation.build<DeleteEventDataStoreRequest, DeleteEventDataStoreResponse> {
            serializer = DeleteEventDataStoreOperationSerializer()
            deserializer = DeleteEventDataStoreOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEventDataStore"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a trail. This operation must be called from the region in which the trail was created. `DeleteTrail` cannot be called on the shadow trails (replicated trails in other regions) of a trail that is enabled in all regions.
     */
    override suspend fun deleteTrail(input: DeleteTrailRequest): DeleteTrailResponse {
        val op = SdkHttpOperation.build<DeleteTrailRequest, DeleteTrailResponse> {
            serializer = DeleteTrailOperationSerializer()
            deserializer = DeleteTrailOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTrail"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata about a query, including query run time in milliseconds, number of events scanned and matched, and query status. You must specify an ARN for `EventDataStore`, and a value for `QueryID`.
     */
    override suspend fun describeQuery(input: DescribeQueryRequest): DescribeQueryResponse {
        val op = SdkHttpOperation.build<DescribeQueryRequest, DescribeQueryResponse> {
            serializer = DescribeQueryOperationSerializer()
            deserializer = DescribeQueryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeQuery"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves settings for one or more trails associated with the current region for your account.
     */
    override suspend fun describeTrails(input: DescribeTrailsRequest): DescribeTrailsResponse {
        val op = SdkHttpOperation.build<DescribeTrailsRequest, DescribeTrailsResponse> {
            serializer = DescribeTrailsOperationSerializer()
            deserializer = DescribeTrailsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTrails"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about an event data store specified as either an ARN or the ID portion of the ARN.
     */
    override suspend fun getEventDataStore(input: GetEventDataStoreRequest): GetEventDataStoreResponse {
        val op = SdkHttpOperation.build<GetEventDataStoreRequest, GetEventDataStoreResponse> {
            serializer = GetEventDataStoreOperationSerializer()
            deserializer = GetEventDataStoreOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEventDataStore"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the settings for the event selectors that you configured for your trail. The information returned for your event selectors includes the following:
     * + If your event selector includes read-only events, write-only events, or all events. This applies to both management events and data events.
     * + If your event selector includes management events.
     * + If your event selector includes data events, the resources on which you are logging data events.
     *
     * For more information, see [Logging Data and Management Events for Trails ](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
     */
    override suspend fun getEventSelectors(input: GetEventSelectorsRequest): GetEventSelectorsResponse {
        val op = SdkHttpOperation.build<GetEventSelectorsRequest, GetEventSelectorsResponse> {
            serializer = GetEventSelectorsOperationSerializer()
            deserializer = GetEventSelectorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEventSelectors"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the settings for the Insights event selectors that you configured for your trail. `GetInsightSelectors` shows if CloudTrail Insights event logging is enabled on the trail, and if it is, which insight types are enabled. If you run `GetInsightSelectors` on a trail that does not have Insights events enabled, the operation throws the exception `InsightNotEnabledException`
     *
     * For more information, see [Logging CloudTrail Insights Events for Trails ](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
     */
    override suspend fun getInsightSelectors(input: GetInsightSelectorsRequest): GetInsightSelectorsResponse {
        val op = SdkHttpOperation.build<GetInsightSelectorsRequest, GetInsightSelectorsResponse> {
            serializer = GetInsightSelectorsOperationSerializer()
            deserializer = GetInsightSelectorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInsightSelectors"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets event data results of a query. You must specify the `QueryID` value returned by the `StartQuery` operation, and an ARN for `EventDataStore`.
     */
    override suspend fun getQueryResults(input: GetQueryResultsRequest): GetQueryResultsResponse {
        val op = SdkHttpOperation.build<GetQueryResultsRequest, GetQueryResultsResponse> {
            serializer = GetQueryResultsOperationSerializer()
            deserializer = GetQueryResultsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetQueryResults"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns settings information for a specified trail.
     */
    override suspend fun getTrail(input: GetTrailRequest): GetTrailResponse {
        val op = SdkHttpOperation.build<GetTrailRequest, GetTrailResponse> {
            serializer = GetTrailOperationSerializer()
            deserializer = GetTrailOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTrail"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns trail status from a single region. To return trail status from all regions, you must call the operation on each region.
     */
    override suspend fun getTrailStatus(input: GetTrailStatusRequest): GetTrailStatusResponse {
        val op = SdkHttpOperation.build<GetTrailStatusRequest, GetTrailStatusResponse> {
            serializer = GetTrailStatusOperationSerializer()
            deserializer = GetTrailStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTrailStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about all event data stores in the account, in the current region.
     */
    override suspend fun listEventDataStores(input: ListEventDataStoresRequest): ListEventDataStoresResponse {
        val op = SdkHttpOperation.build<ListEventDataStoresRequest, ListEventDataStoresResponse> {
            serializer = ListEventDataStoresOperationSerializer()
            deserializer = ListEventDataStoresOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEventDataStores"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns all public keys whose private keys were used to sign the digest files within the specified time range. The public key is needed to validate digest files that were signed with its corresponding private key.
     *
     * CloudTrail uses different private and public key pairs per region. Each digest file is signed with a private key unique to its region. When you validate a digest file from a specific region, you must look in the same region for its corresponding public key.
     */
    override suspend fun listPublicKeys(input: ListPublicKeysRequest): ListPublicKeysResponse {
        val op = SdkHttpOperation.build<ListPublicKeysRequest, ListPublicKeysResponse> {
            serializer = ListPublicKeysOperationSerializer()
            deserializer = ListPublicKeysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPublicKeys"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of queries and query statuses for the past seven days. You must specify an ARN value for `EventDataStore`. Optionally, to shorten the list of results, you can specify a time range, formatted as timestamps, by adding `StartTime` and `EndTime` parameters, and a `QueryStatus` value. Valid values for `QueryStatus` include `QUEUED`, `RUNNING`, `FINISHED`, `FAILED`, `TIMED_OUT`, or `CANCELLED`.
     */
    override suspend fun listQueries(input: ListQueriesRequest): ListQueriesResponse {
        val op = SdkHttpOperation.build<ListQueriesRequest, ListQueriesResponse> {
            serializer = ListQueriesOperationSerializer()
            deserializer = ListQueriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListQueries"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags for the trail or event data store in the current region.
     */
    override suspend fun listTags(input: ListTagsRequest): ListTagsResponse {
        val op = SdkHttpOperation.build<ListTagsRequest, ListTagsResponse> {
            serializer = ListTagsOperationSerializer()
            deserializer = ListTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists trails that are in the current account.
     */
    override suspend fun listTrails(input: ListTrailsRequest): ListTrailsResponse {
        val op = SdkHttpOperation.build<ListTrailsRequest, ListTrailsResponse> {
            serializer = ListTrailsOperationSerializer()
            deserializer = ListTrailsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTrails"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Looks up [management events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events) or [CloudTrail Insights events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events) that are captured by CloudTrail. You can look up events that occurred in a region within the last 90 days. Lookup supports the following attributes for management events:
     * + Amazon Web Services access key
     * + Event ID
     * + Event name
     * + Event source
     * + Read only
     * + Resource name
     * + Resource type
     * + User name
     *
     * Lookup supports the following attributes for Insights events:
     * + Event ID
     * + Event name
     * + Event source
     *
     * All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The response includes a token that you can use to get the next page of results.
     *
     * The rate of lookup requests is limited to two per second, per account, per region. If this limit is exceeded, a throttling error occurs.
     */
    override suspend fun lookupEvents(input: LookupEventsRequest): LookupEventsResponse {
        val op = SdkHttpOperation.build<LookupEventsRequest, LookupEventsResponse> {
            serializer = LookupEventsOperationSerializer()
            deserializer = LookupEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "LookupEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Configures an event selector or advanced event selectors for your trail. Use event selectors or advanced event selectors to specify management and data event settings for your trail. By default, trails created without specific event selectors are configured to log all read and write management events, and no data events.
     *
     * When an event occurs in your account, CloudTrail evaluates the event selectors or advanced event selectors in all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
     *
     * Example
     * + You create an event selector for a trail and specify that you want write-only events.
     * + The EC2 `GetConsoleOutput` and `RunInstances` API operations occur in your account.
     * + CloudTrail evaluates whether the events match your event selectors.
     * + The `RunInstances` is a write-only event and it matches your event selector. The trail logs the event.
     * + The `GetConsoleOutput` is a read-only event that doesn't match your event selector. The trail doesn't log the event.
     *
     * The `PutEventSelectors` operation must be called from the region in which the trail was created; otherwise, an `InvalidHomeRegionException` exception is thrown.
     *
     * You can configure up to five event selectors for each trail. For more information, see [Logging data and management events for trails ](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html) and [Quotas in CloudTrail](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) in the *CloudTrail User Guide*.
     *
     * You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can use either `AdvancedEventSelectors` or `EventSelectors`, but not both. If you apply `AdvancedEventSelectors` to a trail, any existing `EventSelectors` are overwritten. For more information about advanced event selectors, see [Logging data events for trails](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
     */
    override suspend fun putEventSelectors(input: PutEventSelectorsRequest): PutEventSelectorsResponse {
        val op = SdkHttpOperation.build<PutEventSelectorsRequest, PutEventSelectorsResponse> {
            serializer = PutEventSelectorsOperationSerializer()
            deserializer = PutEventSelectorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutEventSelectors"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an existing trail. You also use `PutInsightSelectors` to turn off Insights event logging, by passing an empty list of insight types. The valid Insights event types in this release are `ApiErrorRateInsight` and `ApiCallRateInsight`.
     */
    override suspend fun putInsightSelectors(input: PutInsightSelectorsRequest): PutInsightSelectorsResponse {
        val op = SdkHttpOperation.build<PutInsightSelectorsRequest, PutInsightSelectorsResponse> {
            serializer = PutInsightSelectorsOperationSerializer()
            deserializer = PutInsightSelectorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutInsightSelectors"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified tags from a trail or event data store.
     */
    override suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse {
        val op = SdkHttpOperation.build<RemoveTagsRequest, RemoveTagsResponse> {
            serializer = RemoveTagsOperationSerializer()
            deserializer = RemoveTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Restores a deleted event data store specified by `EventDataStore`, which accepts an event data store ARN. You can only restore a deleted event data store within the seven-day wait period after deletion. Restoring an event data store can take several minutes, depending on the size of the event data store.
     */
    override suspend fun restoreEventDataStore(input: RestoreEventDataStoreRequest): RestoreEventDataStoreResponse {
        val op = SdkHttpOperation.build<RestoreEventDataStoreRequest, RestoreEventDataStoreResponse> {
            serializer = RestoreEventDataStoreOperationSerializer()
            deserializer = RestoreEventDataStoreOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestoreEventDataStore"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts the recording of Amazon Web Services API calls and log file delivery for a trail. For a trail that is enabled in all regions, this operation must be called from the region in which the trail was created. This operation cannot be called on the shadow trails (replicated trails in other regions) of a trail that is enabled in all regions.
     */
    override suspend fun startLogging(input: StartLoggingRequest): StartLoggingResponse {
        val op = SdkHttpOperation.build<StartLoggingRequest, StartLoggingResponse> {
            serializer = StartLoggingOperationSerializer()
            deserializer = StartLoggingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartLogging"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a CloudTrail Lake query. The required `QueryStatement` parameter provides your SQL query, enclosed in single quotation marks.
     */
    override suspend fun startQuery(input: StartQueryRequest): StartQueryResponse {
        val op = SdkHttpOperation.build<StartQueryRequest, StartQueryResponse> {
            serializer = StartQueryOperationSerializer()
            deserializer = StartQueryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartQuery"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail. Under most circumstances, there is no need to use this action. You can update a trail without stopping it first. This action is the only way to stop recording. For a trail enabled in all regions, this operation must be called from the region in which the trail was created, or an `InvalidHomeRegionException` will occur. This operation cannot be called on the shadow trails (replicated trails in other regions) of a trail enabled in all regions.
     */
    override suspend fun stopLogging(input: StopLoggingRequest): StopLoggingResponse {
        val op = SdkHttpOperation.build<StopLoggingRequest, StopLoggingResponse> {
            serializer = StopLoggingOperationSerializer()
            deserializer = StopLoggingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopLogging"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an event data store. The required `EventDataStore` value is an ARN or the ID portion of the ARN. Other parameters are optional, but at least one optional parameter must be specified, or CloudTrail throws an error. `RetentionPeriod` is in days, and valid values are integers between 90 and 2555. By default, `TerminationProtection` is enabled. `AdvancedEventSelectors` includes or excludes management and data events in your event data store; for more information about `AdvancedEventSelectors`, see PutEventSelectorsRequest$AdvancedEventSelectors.
     */
    override suspend fun updateEventDataStore(input: UpdateEventDataStoreRequest): UpdateEventDataStoreResponse {
        val op = SdkHttpOperation.build<UpdateEventDataStoreRequest, UpdateEventDataStoreResponse> {
            serializer = UpdateEventDataStoreOperationSerializer()
            deserializer = UpdateEventDataStoreOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEventDataStore"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates trail settings that control what events you are logging, and how to handle log files. Changes to a trail do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery. If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the bucket. `UpdateTrail` must be called from the region in which the trail was created; otherwise, an `InvalidHomeRegionException` is thrown.
     */
    override suspend fun updateTrail(input: UpdateTrailRequest): UpdateTrailResponse {
        val op = SdkHttpOperation.build<UpdateTrailRequest, UpdateTrailResponse> {
            serializer = UpdateTrailOperationSerializer()
            deserializer = UpdateTrailOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTrail"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CloudTrail_20131101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudtrail"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "cloudtrail")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
