// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.cloudtrail.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.cloudtrail.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # CloudTrail
 * This is the CloudTrail API Reference. It provides descriptions of actions, data types, common parameters, and common errors for CloudTrail.
 *
 * CloudTrail is a web service that records Amazon Web Services API calls for your Amazon Web Services account and delivers log files to an Amazon S3 bucket. The recorded information includes the identity of the user, the start time of the Amazon Web Services API call, the source IP address, the request parameters, and the response elements returned by the service.
 *
 * As an alternative to the API, you can use one of the Amazon Web Services SDKs, which consist of libraries and sample code for various programming languages and platforms (Java, Ruby, .NET, iOS, Android, etc.). The SDKs provide programmatic access to CloudTrail. For example, the SDKs handle cryptographically signing requests, managing errors, and retrying requests automatically. For more information about the Amazon Web Services SDKs, including how to download and install them, see [Tools to Build on Amazon Web Services](http://aws.amazon.com/tools/).
 *
 * See the [CloudTrail User Guide](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-user-guide.html) for information about the data that is included with each Amazon Web Services API call listed in the log files.
 */
interface CloudTrailClient : SdkClient {

    override val serviceName: String
        get() = "CloudTrail"
    /**
     * CloudTrailClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): CloudTrailClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCloudTrailClient(config)
        }

        operator fun invoke(config: Config): CloudTrailClient = DefaultCloudTrailClient(config)

        /**
         * Construct a [CloudTrailClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CloudTrailClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultCloudTrailClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds one or more tags to a trail or event data store, up to a limit of 50. Overwrites an existing tag's value when a new value is specified for an existing tag key. Tag key names must be unique for a trail; you cannot have two keys with the same name but different values. If you specify a key without a value, the tag will be created with the specified key and a value of null. You can tag a trail or event data store that applies to all Amazon Web Services Regions only from the Region in which the trail or event data store was created (also known as its home region).
     */
    suspend fun addTags(input: AddTagsRequest): AddTagsResponse

    /**
     * Adds one or more tags to a trail or event data store, up to a limit of 50. Overwrites an existing tag's value when a new value is specified for an existing tag key. Tag key names must be unique for a trail; you cannot have two keys with the same name but different values. If you specify a key without a value, the tag will be created with the specified key and a value of null. You can tag a trail or event data store that applies to all Amazon Web Services Regions only from the Region in which the trail or event data store was created (also known as its home region).
     */
    suspend fun addTags(block: AddTagsRequest.Builder.() -> Unit) = addTags(AddTagsRequest.Builder().apply(block).build())

    /**
     * Cancels a query if the query is not in a terminated state, such as `CANCELLED`, `FAILED`, `TIMED_OUT`, or `FINISHED`. You must specify an ARN value for `EventDataStore`. The ID of the query that you want to cancel is also required. When you run `CancelQuery`, the query status might show as `CANCELLED` even if the operation is not yet finished.
     */
    suspend fun cancelQuery(input: CancelQueryRequest): CancelQueryResponse

    /**
     * Cancels a query if the query is not in a terminated state, such as `CANCELLED`, `FAILED`, `TIMED_OUT`, or `FINISHED`. You must specify an ARN value for `EventDataStore`. The ID of the query that you want to cancel is also required. When you run `CancelQuery`, the query status might show as `CANCELLED` even if the operation is not yet finished.
     */
    suspend fun cancelQuery(block: CancelQueryRequest.Builder.() -> Unit) = cancelQuery(CancelQueryRequest.Builder().apply(block).build())

    /**
     * Creates a new event data store.
     */
    suspend fun createEventDataStore(input: CreateEventDataStoreRequest): CreateEventDataStoreResponse

    /**
     * Creates a new event data store.
     */
    suspend fun createEventDataStore(block: CreateEventDataStoreRequest.Builder.() -> Unit) = createEventDataStore(CreateEventDataStoreRequest.Builder().apply(block).build())

    /**
     * Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
     */
    suspend fun createTrail(input: CreateTrailRequest): CreateTrailResponse

    /**
     * Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
     */
    suspend fun createTrail(block: CreateTrailRequest.Builder.() -> Unit) = createTrail(CreateTrailRequest.Builder().apply(block).build())

    /**
     * Disables the event data store specified by `EventDataStore`, which accepts an event data store ARN. After you run `DeleteEventDataStore`, the event data store enters a `PENDING_DELETION` state, and is automatically deleted after a wait period of seven days. `TerminationProtectionEnabled` must be set to `False` on the event data store; this operation cannot work if `TerminationProtectionEnabled` is `True`.
     *
     * After you run `DeleteEventDataStore` on an event data store, you cannot run `ListQueries`, `DescribeQuery`, or `GetQueryResults` on queries that are using an event data store in a `PENDING_DELETION` state. An event data store in the `PENDING_DELETION` state does not incur costs.
     */
    suspend fun deleteEventDataStore(input: DeleteEventDataStoreRequest): DeleteEventDataStoreResponse

    /**
     * Disables the event data store specified by `EventDataStore`, which accepts an event data store ARN. After you run `DeleteEventDataStore`, the event data store enters a `PENDING_DELETION` state, and is automatically deleted after a wait period of seven days. `TerminationProtectionEnabled` must be set to `False` on the event data store; this operation cannot work if `TerminationProtectionEnabled` is `True`.
     *
     * After you run `DeleteEventDataStore` on an event data store, you cannot run `ListQueries`, `DescribeQuery`, or `GetQueryResults` on queries that are using an event data store in a `PENDING_DELETION` state. An event data store in the `PENDING_DELETION` state does not incur costs.
     */
    suspend fun deleteEventDataStore(block: DeleteEventDataStoreRequest.Builder.() -> Unit) = deleteEventDataStore(DeleteEventDataStoreRequest.Builder().apply(block).build())

    /**
     * Deletes a trail. This operation must be called from the region in which the trail was created. `DeleteTrail` cannot be called on the shadow trails (replicated trails in other regions) of a trail that is enabled in all regions.
     */
    suspend fun deleteTrail(input: DeleteTrailRequest): DeleteTrailResponse

    /**
     * Deletes a trail. This operation must be called from the region in which the trail was created. `DeleteTrail` cannot be called on the shadow trails (replicated trails in other regions) of a trail that is enabled in all regions.
     */
    suspend fun deleteTrail(block: DeleteTrailRequest.Builder.() -> Unit) = deleteTrail(DeleteTrailRequest.Builder().apply(block).build())

    /**
     * Returns metadata about a query, including query run time in milliseconds, number of events scanned and matched, and query status. You must specify an ARN for `EventDataStore`, and a value for `QueryID`.
     */
    suspend fun describeQuery(input: DescribeQueryRequest): DescribeQueryResponse

    /**
     * Returns metadata about a query, including query run time in milliseconds, number of events scanned and matched, and query status. You must specify an ARN for `EventDataStore`, and a value for `QueryID`.
     */
    suspend fun describeQuery(block: DescribeQueryRequest.Builder.() -> Unit) = describeQuery(DescribeQueryRequest.Builder().apply(block).build())

    /**
     * Retrieves settings for one or more trails associated with the current region for your account.
     */
    suspend fun describeTrails(input: DescribeTrailsRequest = DescribeTrailsRequest {}): DescribeTrailsResponse

    /**
     * Retrieves settings for one or more trails associated with the current region for your account.
     */
    suspend fun describeTrails(block: DescribeTrailsRequest.Builder.() -> Unit) = describeTrails(DescribeTrailsRequest.Builder().apply(block).build())

    /**
     * Returns information about an event data store specified as either an ARN or the ID portion of the ARN.
     */
    suspend fun getEventDataStore(input: GetEventDataStoreRequest): GetEventDataStoreResponse

    /**
     * Returns information about an event data store specified as either an ARN or the ID portion of the ARN.
     */
    suspend fun getEventDataStore(block: GetEventDataStoreRequest.Builder.() -> Unit) = getEventDataStore(GetEventDataStoreRequest.Builder().apply(block).build())

    /**
     * Describes the settings for the event selectors that you configured for your trail. The information returned for your event selectors includes the following:
     * + If your event selector includes read-only events, write-only events, or all events. This applies to both management events and data events.
     * + If your event selector includes management events.
     * + If your event selector includes data events, the resources on which you are logging data events.
     *
     * For more information, see [Logging Data and Management Events for Trails ](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
     */
    suspend fun getEventSelectors(input: GetEventSelectorsRequest): GetEventSelectorsResponse

    /**
     * Describes the settings for the event selectors that you configured for your trail. The information returned for your event selectors includes the following:
     * + If your event selector includes read-only events, write-only events, or all events. This applies to both management events and data events.
     * + If your event selector includes management events.
     * + If your event selector includes data events, the resources on which you are logging data events.
     *
     * For more information, see [Logging Data and Management Events for Trails ](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
     */
    suspend fun getEventSelectors(block: GetEventSelectorsRequest.Builder.() -> Unit) = getEventSelectors(GetEventSelectorsRequest.Builder().apply(block).build())

    /**
     * Describes the settings for the Insights event selectors that you configured for your trail. `GetInsightSelectors` shows if CloudTrail Insights event logging is enabled on the trail, and if it is, which insight types are enabled. If you run `GetInsightSelectors` on a trail that does not have Insights events enabled, the operation throws the exception `InsightNotEnabledException`
     *
     * For more information, see [Logging CloudTrail Insights Events for Trails ](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
     */
    suspend fun getInsightSelectors(input: GetInsightSelectorsRequest): GetInsightSelectorsResponse

    /**
     * Describes the settings for the Insights event selectors that you configured for your trail. `GetInsightSelectors` shows if CloudTrail Insights event logging is enabled on the trail, and if it is, which insight types are enabled. If you run `GetInsightSelectors` on a trail that does not have Insights events enabled, the operation throws the exception `InsightNotEnabledException`
     *
     * For more information, see [Logging CloudTrail Insights Events for Trails ](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
     */
    suspend fun getInsightSelectors(block: GetInsightSelectorsRequest.Builder.() -> Unit) = getInsightSelectors(GetInsightSelectorsRequest.Builder().apply(block).build())

    /**
     * Gets event data results of a query. You must specify the `QueryID` value returned by the `StartQuery` operation, and an ARN for `EventDataStore`.
     */
    suspend fun getQueryResults(input: GetQueryResultsRequest): GetQueryResultsResponse

    /**
     * Gets event data results of a query. You must specify the `QueryID` value returned by the `StartQuery` operation, and an ARN for `EventDataStore`.
     */
    suspend fun getQueryResults(block: GetQueryResultsRequest.Builder.() -> Unit) = getQueryResults(GetQueryResultsRequest.Builder().apply(block).build())

    /**
     * Returns settings information for a specified trail.
     */
    suspend fun getTrail(input: GetTrailRequest): GetTrailResponse

    /**
     * Returns settings information for a specified trail.
     */
    suspend fun getTrail(block: GetTrailRequest.Builder.() -> Unit) = getTrail(GetTrailRequest.Builder().apply(block).build())

    /**
     * Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns trail status from a single region. To return trail status from all regions, you must call the operation on each region.
     */
    suspend fun getTrailStatus(input: GetTrailStatusRequest): GetTrailStatusResponse

    /**
     * Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns trail status from a single region. To return trail status from all regions, you must call the operation on each region.
     */
    suspend fun getTrailStatus(block: GetTrailStatusRequest.Builder.() -> Unit) = getTrailStatus(GetTrailStatusRequest.Builder().apply(block).build())

    /**
     * Returns information about all event data stores in the account, in the current region.
     */
    suspend fun listEventDataStores(input: ListEventDataStoresRequest = ListEventDataStoresRequest {}): ListEventDataStoresResponse

    /**
     * Returns information about all event data stores in the account, in the current region.
     */
    suspend fun listEventDataStores(block: ListEventDataStoresRequest.Builder.() -> Unit) = listEventDataStores(ListEventDataStoresRequest.Builder().apply(block).build())

    /**
     * Returns all public keys whose private keys were used to sign the digest files within the specified time range. The public key is needed to validate digest files that were signed with its corresponding private key.
     *
     * CloudTrail uses different private and public key pairs per region. Each digest file is signed with a private key unique to its region. When you validate a digest file from a specific region, you must look in the same region for its corresponding public key.
     */
    suspend fun listPublicKeys(input: ListPublicKeysRequest = ListPublicKeysRequest {}): ListPublicKeysResponse

    /**
     * Returns all public keys whose private keys were used to sign the digest files within the specified time range. The public key is needed to validate digest files that were signed with its corresponding private key.
     *
     * CloudTrail uses different private and public key pairs per region. Each digest file is signed with a private key unique to its region. When you validate a digest file from a specific region, you must look in the same region for its corresponding public key.
     */
    suspend fun listPublicKeys(block: ListPublicKeysRequest.Builder.() -> Unit) = listPublicKeys(ListPublicKeysRequest.Builder().apply(block).build())

    /**
     * Returns a list of queries and query statuses for the past seven days. You must specify an ARN value for `EventDataStore`. Optionally, to shorten the list of results, you can specify a time range, formatted as timestamps, by adding `StartTime` and `EndTime` parameters, and a `QueryStatus` value. Valid values for `QueryStatus` include `QUEUED`, `RUNNING`, `FINISHED`, `FAILED`, `TIMED_OUT`, or `CANCELLED`.
     */
    suspend fun listQueries(input: ListQueriesRequest): ListQueriesResponse

    /**
     * Returns a list of queries and query statuses for the past seven days. You must specify an ARN value for `EventDataStore`. Optionally, to shorten the list of results, you can specify a time range, formatted as timestamps, by adding `StartTime` and `EndTime` parameters, and a `QueryStatus` value. Valid values for `QueryStatus` include `QUEUED`, `RUNNING`, `FINISHED`, `FAILED`, `TIMED_OUT`, or `CANCELLED`.
     */
    suspend fun listQueries(block: ListQueriesRequest.Builder.() -> Unit) = listQueries(ListQueriesRequest.Builder().apply(block).build())

    /**
     * Lists the tags for the trail or event data store in the current region.
     */
    suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Lists the tags for the trail or event data store in the current region.
     */
    suspend fun listTags(block: ListTagsRequest.Builder.() -> Unit) = listTags(ListTagsRequest.Builder().apply(block).build())

    /**
     * Lists trails that are in the current account.
     */
    suspend fun listTrails(input: ListTrailsRequest = ListTrailsRequest {}): ListTrailsResponse

    /**
     * Lists trails that are in the current account.
     */
    suspend fun listTrails(block: ListTrailsRequest.Builder.() -> Unit) = listTrails(ListTrailsRequest.Builder().apply(block).build())

    /**
     * Looks up [management events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events) or [CloudTrail Insights events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events) that are captured by CloudTrail. You can look up events that occurred in a region within the last 90 days. Lookup supports the following attributes for management events:
     * + Amazon Web Services access key
     * + Event ID
     * + Event name
     * + Event source
     * + Read only
     * + Resource name
     * + Resource type
     * + User name
     *
     * Lookup supports the following attributes for Insights events:
     * + Event ID
     * + Event name
     * + Event source
     *
     * All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The response includes a token that you can use to get the next page of results.
     *
     * The rate of lookup requests is limited to two per second, per account, per region. If this limit is exceeded, a throttling error occurs.
     */
    suspend fun lookupEvents(input: LookupEventsRequest = LookupEventsRequest {}): LookupEventsResponse

    /**
     * Looks up [management events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events) or [CloudTrail Insights events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events) that are captured by CloudTrail. You can look up events that occurred in a region within the last 90 days. Lookup supports the following attributes for management events:
     * + Amazon Web Services access key
     * + Event ID
     * + Event name
     * + Event source
     * + Read only
     * + Resource name
     * + Resource type
     * + User name
     *
     * Lookup supports the following attributes for Insights events:
     * + Event ID
     * + Event name
     * + Event source
     *
     * All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The response includes a token that you can use to get the next page of results.
     *
     * The rate of lookup requests is limited to two per second, per account, per region. If this limit is exceeded, a throttling error occurs.
     */
    suspend fun lookupEvents(block: LookupEventsRequest.Builder.() -> Unit) = lookupEvents(LookupEventsRequest.Builder().apply(block).build())

    /**
     * Configures an event selector or advanced event selectors for your trail. Use event selectors or advanced event selectors to specify management and data event settings for your trail. By default, trails created without specific event selectors are configured to log all read and write management events, and no data events.
     *
     * When an event occurs in your account, CloudTrail evaluates the event selectors or advanced event selectors in all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
     *
     * Example
     * + You create an event selector for a trail and specify that you want write-only events.
     * + The EC2 `GetConsoleOutput` and `RunInstances` API operations occur in your account.
     * + CloudTrail evaluates whether the events match your event selectors.
     * + The `RunInstances` is a write-only event and it matches your event selector. The trail logs the event.
     * + The `GetConsoleOutput` is a read-only event that doesn't match your event selector. The trail doesn't log the event.
     *
     * The `PutEventSelectors` operation must be called from the region in which the trail was created; otherwise, an `InvalidHomeRegionException` exception is thrown.
     *
     * You can configure up to five event selectors for each trail. For more information, see [Logging data and management events for trails ](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html) and [Quotas in CloudTrail](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) in the *CloudTrail User Guide*.
     *
     * You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can use either `AdvancedEventSelectors` or `EventSelectors`, but not both. If you apply `AdvancedEventSelectors` to a trail, any existing `EventSelectors` are overwritten. For more information about advanced event selectors, see [Logging data events for trails](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
     */
    suspend fun putEventSelectors(input: PutEventSelectorsRequest): PutEventSelectorsResponse

    /**
     * Configures an event selector or advanced event selectors for your trail. Use event selectors or advanced event selectors to specify management and data event settings for your trail. By default, trails created without specific event selectors are configured to log all read and write management events, and no data events.
     *
     * When an event occurs in your account, CloudTrail evaluates the event selectors or advanced event selectors in all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
     *
     * Example
     * + You create an event selector for a trail and specify that you want write-only events.
     * + The EC2 `GetConsoleOutput` and `RunInstances` API operations occur in your account.
     * + CloudTrail evaluates whether the events match your event selectors.
     * + The `RunInstances` is a write-only event and it matches your event selector. The trail logs the event.
     * + The `GetConsoleOutput` is a read-only event that doesn't match your event selector. The trail doesn't log the event.
     *
     * The `PutEventSelectors` operation must be called from the region in which the trail was created; otherwise, an `InvalidHomeRegionException` exception is thrown.
     *
     * You can configure up to five event selectors for each trail. For more information, see [Logging data and management events for trails ](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html) and [Quotas in CloudTrail](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) in the *CloudTrail User Guide*.
     *
     * You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can use either `AdvancedEventSelectors` or `EventSelectors`, but not both. If you apply `AdvancedEventSelectors` to a trail, any existing `EventSelectors` are overwritten. For more information about advanced event selectors, see [Logging data events for trails](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
     */
    suspend fun putEventSelectors(block: PutEventSelectorsRequest.Builder.() -> Unit) = putEventSelectors(PutEventSelectorsRequest.Builder().apply(block).build())

    /**
     * Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an existing trail. You also use `PutInsightSelectors` to turn off Insights event logging, by passing an empty list of insight types. The valid Insights event types in this release are `ApiErrorRateInsight` and `ApiCallRateInsight`.
     */
    suspend fun putInsightSelectors(input: PutInsightSelectorsRequest): PutInsightSelectorsResponse

    /**
     * Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an existing trail. You also use `PutInsightSelectors` to turn off Insights event logging, by passing an empty list of insight types. The valid Insights event types in this release are `ApiErrorRateInsight` and `ApiCallRateInsight`.
     */
    suspend fun putInsightSelectors(block: PutInsightSelectorsRequest.Builder.() -> Unit) = putInsightSelectors(PutInsightSelectorsRequest.Builder().apply(block).build())

    /**
     * Removes the specified tags from a trail or event data store.
     */
    suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse

    /**
     * Removes the specified tags from a trail or event data store.
     */
    suspend fun removeTags(block: RemoveTagsRequest.Builder.() -> Unit) = removeTags(RemoveTagsRequest.Builder().apply(block).build())

    /**
     * Restores a deleted event data store specified by `EventDataStore`, which accepts an event data store ARN. You can only restore a deleted event data store within the seven-day wait period after deletion. Restoring an event data store can take several minutes, depending on the size of the event data store.
     */
    suspend fun restoreEventDataStore(input: RestoreEventDataStoreRequest): RestoreEventDataStoreResponse

    /**
     * Restores a deleted event data store specified by `EventDataStore`, which accepts an event data store ARN. You can only restore a deleted event data store within the seven-day wait period after deletion. Restoring an event data store can take several minutes, depending on the size of the event data store.
     */
    suspend fun restoreEventDataStore(block: RestoreEventDataStoreRequest.Builder.() -> Unit) = restoreEventDataStore(RestoreEventDataStoreRequest.Builder().apply(block).build())

    /**
     * Starts the recording of Amazon Web Services API calls and log file delivery for a trail. For a trail that is enabled in all regions, this operation must be called from the region in which the trail was created. This operation cannot be called on the shadow trails (replicated trails in other regions) of a trail that is enabled in all regions.
     */
    suspend fun startLogging(input: StartLoggingRequest): StartLoggingResponse

    /**
     * Starts the recording of Amazon Web Services API calls and log file delivery for a trail. For a trail that is enabled in all regions, this operation must be called from the region in which the trail was created. This operation cannot be called on the shadow trails (replicated trails in other regions) of a trail that is enabled in all regions.
     */
    suspend fun startLogging(block: StartLoggingRequest.Builder.() -> Unit) = startLogging(StartLoggingRequest.Builder().apply(block).build())

    /**
     * Starts a CloudTrail Lake query. The required `QueryStatement` parameter provides your SQL query, enclosed in single quotation marks.
     */
    suspend fun startQuery(input: StartQueryRequest): StartQueryResponse

    /**
     * Starts a CloudTrail Lake query. The required `QueryStatement` parameter provides your SQL query, enclosed in single quotation marks.
     */
    suspend fun startQuery(block: StartQueryRequest.Builder.() -> Unit) = startQuery(StartQueryRequest.Builder().apply(block).build())

    /**
     * Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail. Under most circumstances, there is no need to use this action. You can update a trail without stopping it first. This action is the only way to stop recording. For a trail enabled in all regions, this operation must be called from the region in which the trail was created, or an `InvalidHomeRegionException` will occur. This operation cannot be called on the shadow trails (replicated trails in other regions) of a trail enabled in all regions.
     */
    suspend fun stopLogging(input: StopLoggingRequest): StopLoggingResponse

    /**
     * Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail. Under most circumstances, there is no need to use this action. You can update a trail without stopping it first. This action is the only way to stop recording. For a trail enabled in all regions, this operation must be called from the region in which the trail was created, or an `InvalidHomeRegionException` will occur. This operation cannot be called on the shadow trails (replicated trails in other regions) of a trail enabled in all regions.
     */
    suspend fun stopLogging(block: StopLoggingRequest.Builder.() -> Unit) = stopLogging(StopLoggingRequest.Builder().apply(block).build())

    /**
     * Updates an event data store. The required `EventDataStore` value is an ARN or the ID portion of the ARN. Other parameters are optional, but at least one optional parameter must be specified, or CloudTrail throws an error. `RetentionPeriod` is in days, and valid values are integers between 90 and 2555. By default, `TerminationProtection` is enabled. `AdvancedEventSelectors` includes or excludes management and data events in your event data store; for more information about `AdvancedEventSelectors`, see PutEventSelectorsRequest$AdvancedEventSelectors.
     */
    suspend fun updateEventDataStore(input: UpdateEventDataStoreRequest): UpdateEventDataStoreResponse

    /**
     * Updates an event data store. The required `EventDataStore` value is an ARN or the ID portion of the ARN. Other parameters are optional, but at least one optional parameter must be specified, or CloudTrail throws an error. `RetentionPeriod` is in days, and valid values are integers between 90 and 2555. By default, `TerminationProtection` is enabled. `AdvancedEventSelectors` includes or excludes management and data events in your event data store; for more information about `AdvancedEventSelectors`, see PutEventSelectorsRequest$AdvancedEventSelectors.
     */
    suspend fun updateEventDataStore(block: UpdateEventDataStoreRequest.Builder.() -> Unit) = updateEventDataStore(UpdateEventDataStoreRequest.Builder().apply(block).build())

    /**
     * Updates trail settings that control what events you are logging, and how to handle log files. Changes to a trail do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery. If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the bucket. `UpdateTrail` must be called from the region in which the trail was created; otherwise, an `InvalidHomeRegionException` is thrown.
     */
    suspend fun updateTrail(input: UpdateTrailRequest): UpdateTrailResponse

    /**
     * Updates trail settings that control what events you are logging, and how to handle log files. Changes to a trail do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery. If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the bucket. `UpdateTrail` must be called from the region in which the trail was created; otherwise, an `InvalidHomeRegionException` is thrown.
     */
    suspend fun updateTrail(block: UpdateTrailRequest.Builder.() -> Unit) = updateTrail(UpdateTrailRequest.Builder().apply(block).build())
}
