// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearchdomain.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudsearchdomain.model.CloudSearchDomainException
import aws.sdk.kotlin.services.cloudsearchdomain.model.DocumentServiceWarning
import aws.sdk.kotlin.services.cloudsearchdomain.model.UploadDocumentsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UploadDocumentsOperationDeserializer: HttpDeserialize<UploadDocumentsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UploadDocumentsResponse {
        if (!response.status.isSuccess()) {
            throwUploadDocumentsError(context, response)
        }
        val builder = UploadDocumentsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUploadDocumentsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUploadDocumentsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudSearchDomainException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DocumentServiceException" -> DocumentServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudSearchDomainException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUploadDocumentsOperationBody(builder: UploadDocumentsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("adds"))
    val DELETES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("deletes"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val WARNINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("warnings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDS_DESCRIPTOR)
        field(DELETES_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(WARNINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDS_DESCRIPTOR.index -> builder.adds = deserializeLong()
                DELETES_DESCRIPTOR.index -> builder.deletes = deserializeLong()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                WARNINGS_DESCRIPTOR.index -> builder.warnings =
                    deserializer.deserializeList(WARNINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<DocumentServiceWarning>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDocumentServiceWarningDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
