// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearchdomain.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudsearchdomain.model.CloudSearchDomainException
import aws.sdk.kotlin.services.cloudsearchdomain.model.SuggestModel
import aws.sdk.kotlin.services.cloudsearchdomain.model.SuggestResponse
import aws.sdk.kotlin.services.cloudsearchdomain.model.SuggestStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SuggestOperationDeserializer: HttpDeserialize<SuggestResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SuggestResponse {
        if (!response.status.isSuccess()) {
            throwSuggestError(context, response)
        }
        val builder = SuggestResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSuggestOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwSuggestError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudSearchDomainException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "SearchException" -> SearchExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudSearchDomainException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSuggestOperationBody(builder: SuggestResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("status"))
    val SUGGEST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("suggest"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(STATUS_DESCRIPTOR)
        field(SUGGEST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                STATUS_DESCRIPTOR.index -> builder.status = deserializeSuggestStatusDocument(deserializer)
                SUGGEST_DESCRIPTOR.index -> builder.suggest = deserializeSuggestModelDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
