// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearchdomain.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudsearchdomain.model.BucketInfo
import aws.sdk.kotlin.services.cloudsearchdomain.model.CloudSearchDomainException
import aws.sdk.kotlin.services.cloudsearchdomain.model.FieldStats
import aws.sdk.kotlin.services.cloudsearchdomain.model.Hits
import aws.sdk.kotlin.services.cloudsearchdomain.model.SearchResponse
import aws.sdk.kotlin.services.cloudsearchdomain.model.SearchStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SearchOperationDeserializer: HttpDeserialize<SearchResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SearchResponse {
        if (!response.status.isSuccess()) {
            throwSearchError(context, response)
        }
        val builder = SearchResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSearchOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwSearchError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudSearchDomainException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "SearchException" -> SearchExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudSearchDomainException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSearchOperationBody(builder: SearchResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FACETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("facets"))
    val HITS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("hits"))
    val STATS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("stats"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FACETS_DESCRIPTOR)
        field(HITS_DESCRIPTOR)
        field(STATS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FACETS_DESCRIPTOR.index -> builder.facets =
                    deserializer.deserializeMap(FACETS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, BucketInfo>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeBucketInfoDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                HITS_DESCRIPTOR.index -> builder.hits = deserializeHitsDocument(deserializer)
                STATS_DESCRIPTOR.index -> builder.stats =
                    deserializer.deserializeMap(STATS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, FieldStats>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeFieldStatsDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeSearchStatusDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
