// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudsearch.model.CloudSearchException
import aws.sdk.kotlin.services.cloudsearch.model.DescribeSuggestersResponse
import aws.sdk.kotlin.services.cloudsearch.model.SuggesterStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DescribeSuggestersOperationDeserializer: HttpDeserialize<DescribeSuggestersResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeSuggestersResponse {
        if (!response.status.isSuccess()) {
            throwDescribeSuggestersError(context, response)
        }
        val builder = DescribeSuggestersResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeSuggestersOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeSuggestersOperationBody(builder: DescribeSuggestersResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)

    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeSuggestersResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeSuggestersResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeSuggesters response")
    }

    val SUGGESTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Suggesters"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://cloudsearch.amazonaws.com/doc/2013-01-01/"))
        trait(XmlSerialName("DescribeSuggestersResult"))
        field(SUGGESTERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SUGGESTERS_DESCRIPTOR.index -> builder.suggesters =
                    deserializer.deserializeList(SUGGESTERS_DESCRIPTOR) {
                        val col0 = mutableListOf<SuggesterStatus>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSuggesterStatusDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeSuggestersError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer()
        "InternalException" -> InternalExceptionDeserializer()
        "ResourceNotFound" -> ResourceNotFoundExceptionDeserializer()
        else -> throw CloudSearchException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
