// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudsearch.model.CloudSearchException
import aws.sdk.kotlin.services.cloudsearch.model.DescribeExpressionsResponse
import aws.sdk.kotlin.services.cloudsearch.model.ExpressionStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DescribeExpressionsOperationDeserializer: HttpDeserialize<DescribeExpressionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeExpressionsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeExpressionsError(context, response)
        }
        val builder = DescribeExpressionsResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeExpressionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeExpressionsOperationBody(builder: DescribeExpressionsResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)

    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeExpressionsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeExpressionsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeExpressions response")
    }

    val EXPRESSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Expressions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://cloudsearch.amazonaws.com/doc/2013-01-01/"))
        trait(XmlSerialName("DescribeExpressionsResult"))
        field(EXPRESSIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXPRESSIONS_DESCRIPTOR.index -> builder.expressions =
                    deserializer.deserializeList(EXPRESSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ExpressionStatus>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeExpressionStatusDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeExpressionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer()
        "InternalException" -> InternalExceptionDeserializer()
        "ResourceNotFound" -> ResourceNotFoundExceptionDeserializer()
        else -> throw CloudSearchException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
