// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudsearch.model.CloudSearchException
import aws.sdk.kotlin.services.cloudsearch.model.DescribeDomainEndpointOptionsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DescribeDomainEndpointOptionsOperationDeserializer: HttpDeserialize<DescribeDomainEndpointOptionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeDomainEndpointOptionsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeDomainEndpointOptionsError(context, response)
        }
        val builder = DescribeDomainEndpointOptionsResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDomainEndpointOptionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeDomainEndpointOptionsOperationBody(builder: DescribeDomainEndpointOptionsResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)

    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeDomainEndpointOptionsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeDomainEndpointOptionsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeDomainEndpointOptions response")
    }

    val DOMAINENDPOINTOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DomainEndpointOptions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://cloudsearch.amazonaws.com/doc/2013-01-01/"))
        trait(XmlSerialName("DescribeDomainEndpointOptionsResult"))
        field(DOMAINENDPOINTOPTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOMAINENDPOINTOPTIONS_DESCRIPTOR.index -> builder.domainEndpointOptions = deserializeDomainEndpointOptionsStatusDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeDomainEndpointOptionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer()
        "DisabledAction" -> DisabledOperationExceptionDeserializer()
        "InternalException" -> InternalExceptionDeserializer()
        "LimitExceeded" -> LimitExceededExceptionDeserializer()
        "ResourceNotFound" -> ResourceNotFoundExceptionDeserializer()
        else -> throw CloudSearchException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
