// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudsearch.model.AnalysisSchemeStatus
import aws.sdk.kotlin.services.cloudsearch.model.CloudSearchException
import aws.sdk.kotlin.services.cloudsearch.model.DescribeAnalysisSchemesResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DescribeAnalysisSchemesOperationDeserializer: HttpDeserialize<DescribeAnalysisSchemesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAnalysisSchemesResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAnalysisSchemesError(context, response)
        }
        val builder = DescribeAnalysisSchemesResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAnalysisSchemesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeAnalysisSchemesOperationBody(builder: DescribeAnalysisSchemesResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)

    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeAnalysisSchemesResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeAnalysisSchemesResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeAnalysisSchemes response")
    }

    val ANALYSISSCHEMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("AnalysisSchemes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://cloudsearch.amazonaws.com/doc/2013-01-01/"))
        trait(XmlSerialName("DescribeAnalysisSchemesResult"))
        field(ANALYSISSCHEMES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANALYSISSCHEMES_DESCRIPTOR.index -> builder.analysisSchemes =
                    deserializer.deserializeList(ANALYSISSCHEMES_DESCRIPTOR) {
                        val col0 = mutableListOf<AnalysisSchemeStatus>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAnalysisSchemeStatusDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeAnalysisSchemesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer()
        "InternalException" -> InternalExceptionDeserializer()
        "ResourceNotFound" -> ResourceNotFoundExceptionDeserializer()
        else -> throw CloudSearchException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
