// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * Options for text field.  Present if IndexFieldType specifies the field is of type text. A text field is always searchable. All options are enabled by default.
 */
class TextOptions private constructor(builder: BuilderImpl) {
    /**
     * The name of an analysis scheme for a  text field.
     */
    val analysisScheme: String? = builder.analysisScheme
    /**
     * A value to use for the field if the field isn't specified for a document.
     */
    val defaultValue: String? = builder.defaultValue
    /**
     * Whether highlights can be returned for the field.
     */
    val highlightEnabled: Boolean? = builder.highlightEnabled
    /**
     * Whether the contents of the field can be returned in the search results.
     */
    val returnEnabled: Boolean? = builder.returnEnabled
    /**
     * Whether the field can be used to sort the search results.
     */
    val sortEnabled: Boolean? = builder.sortEnabled
    /**
     * A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
     * A dynamic field's name defines a pattern that begins or ends with a wildcard.
     * Any document fields that don't map to a regular index field but do match a
     * dynamic field's pattern are configured with the dynamic field's indexing options.
     * Regular field names begin with a letter and can contain the following characters:
     * a-z (lowercase), 0-9, and _ (underscore).
     * Dynamic field names must begin or end with a wildcard (*).
     * The wildcard can also be the only character in a dynamic field name.
     * Multiple wildcards, and wildcards embedded within a string are not supported.
     * The name score is reserved and cannot be used as a field name.
     * To reference a document's ID, you can use the name _id.
     */
    val sourceField: String? = builder.sourceField

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TextOptions = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TextOptions(")
        append("analysisScheme=$analysisScheme,")
        append("defaultValue=$defaultValue,")
        append("highlightEnabled=$highlightEnabled,")
        append("returnEnabled=$returnEnabled,")
        append("sortEnabled=$sortEnabled,")
        append("sourceField=$sourceField)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisScheme?.hashCode() ?: 0
        result = 31 * result + (defaultValue?.hashCode() ?: 0)
        result = 31 * result + (highlightEnabled?.hashCode() ?: 0)
        result = 31 * result + (returnEnabled?.hashCode() ?: 0)
        result = 31 * result + (sortEnabled?.hashCode() ?: 0)
        result = 31 * result + (sourceField?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TextOptions

        if (analysisScheme != other.analysisScheme) return false
        if (defaultValue != other.defaultValue) return false
        if (highlightEnabled != other.highlightEnabled) return false
        if (returnEnabled != other.returnEnabled) return false
        if (sortEnabled != other.sortEnabled) return false
        if (sourceField != other.sourceField) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TextOptions = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TextOptions
        /**
         * The name of an analysis scheme for a  text field.
         */
        fun analysisScheme(analysisScheme: String): FluentBuilder
        /**
         * A value to use for the field if the field isn't specified for a document.
         */
        fun defaultValue(defaultValue: String): FluentBuilder
        /**
         * Whether highlights can be returned for the field.
         */
        fun highlightEnabled(highlightEnabled: Boolean): FluentBuilder
        /**
         * Whether the contents of the field can be returned in the search results.
         */
        fun returnEnabled(returnEnabled: Boolean): FluentBuilder
        /**
         * Whether the field can be used to sort the search results.
         */
        fun sortEnabled(sortEnabled: Boolean): FluentBuilder
        /**
         * A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
         * A dynamic field's name defines a pattern that begins or ends with a wildcard.
         * Any document fields that don't map to a regular index field but do match a
         * dynamic field's pattern are configured with the dynamic field's indexing options.
         * Regular field names begin with a letter and can contain the following characters:
         * a-z (lowercase), 0-9, and _ (underscore).
         * Dynamic field names must begin or end with a wildcard (*).
         * The wildcard can also be the only character in a dynamic field name.
         * Multiple wildcards, and wildcards embedded within a string are not supported.
         * The name score is reserved and cannot be used as a field name.
         * To reference a document's ID, you can use the name _id.
         */
        fun sourceField(sourceField: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of an analysis scheme for a  text field.
         */
        var analysisScheme: String?
        /**
         * A value to use for the field if the field isn't specified for a document.
         */
        var defaultValue: String?
        /**
         * Whether highlights can be returned for the field.
         */
        var highlightEnabled: Boolean?
        /**
         * Whether the contents of the field can be returned in the search results.
         */
        var returnEnabled: Boolean?
        /**
         * Whether the field can be used to sort the search results.
         */
        var sortEnabled: Boolean?
        /**
         * A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
         * A dynamic field's name defines a pattern that begins or ends with a wildcard.
         * Any document fields that don't map to a regular index field but do match a
         * dynamic field's pattern are configured with the dynamic field's indexing options.
         * Regular field names begin with a letter and can contain the following characters:
         * a-z (lowercase), 0-9, and _ (underscore).
         * Dynamic field names must begin or end with a wildcard (*).
         * The wildcard can also be the only character in a dynamic field name.
         * Multiple wildcards, and wildcards embedded within a string are not supported.
         * The name score is reserved and cannot be used as a field name.
         * To reference a document's ID, you can use the name _id.
         */
        var sourceField: String?

        fun build(): TextOptions
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analysisScheme: String? = null
        override var defaultValue: String? = null
        override var highlightEnabled: Boolean? = null
        override var returnEnabled: Boolean? = null
        override var sortEnabled: Boolean? = null
        override var sourceField: String? = null

        constructor(x: TextOptions) : this() {
            this.analysisScheme = x.analysisScheme
            this.defaultValue = x.defaultValue
            this.highlightEnabled = x.highlightEnabled
            this.returnEnabled = x.returnEnabled
            this.sortEnabled = x.sortEnabled
            this.sourceField = x.sourceField
        }

        override fun build(): TextOptions = TextOptions(this)
        override fun analysisScheme(analysisScheme: String): FluentBuilder = apply { this.analysisScheme = analysisScheme }
        override fun defaultValue(defaultValue: String): FluentBuilder = apply { this.defaultValue = defaultValue }
        override fun highlightEnabled(highlightEnabled: Boolean): FluentBuilder = apply { this.highlightEnabled = highlightEnabled }
        override fun returnEnabled(returnEnabled: Boolean): FluentBuilder = apply { this.returnEnabled = returnEnabled }
        override fun sortEnabled(sortEnabled: Boolean): FluentBuilder = apply { this.sortEnabled = sortEnabled }
        override fun sourceField(sourceField: String): FluentBuilder = apply { this.sourceField = sourceField }
    }
}
