// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * The desired instance type and desired number of replicas of each index partition.
 */
class ScalingParameters private constructor(builder: BuilderImpl) {
    /**
     * The instance type that you want to preconfigure for your domain. For example, search.m1.small.
     */
    val desiredInstanceType: PartitionInstanceType? = builder.desiredInstanceType
    /**
     * The number of partitions you want to preconfigure for your domain. Only valid when
     * you select m2.2xlarge as the desired instance type.
     */
    val desiredPartitionCount: Int = builder.desiredPartitionCount
    /**
     * The number of replicas you want to preconfigure for each index partition.
     */
    val desiredReplicationCount: Int = builder.desiredReplicationCount

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ScalingParameters = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ScalingParameters(")
        append("desiredInstanceType=$desiredInstanceType,")
        append("desiredPartitionCount=$desiredPartitionCount,")
        append("desiredReplicationCount=$desiredReplicationCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = desiredInstanceType?.hashCode() ?: 0
        result = 31 * result + (desiredPartitionCount)
        result = 31 * result + (desiredReplicationCount)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ScalingParameters

        if (desiredInstanceType != other.desiredInstanceType) return false
        if (desiredPartitionCount != other.desiredPartitionCount) return false
        if (desiredReplicationCount != other.desiredReplicationCount) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ScalingParameters = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ScalingParameters
        /**
         * The instance type that you want to preconfigure for your domain. For example, search.m1.small.
         */
        fun desiredInstanceType(desiredInstanceType: PartitionInstanceType): FluentBuilder
        /**
         * The number of partitions you want to preconfigure for your domain. Only valid when
         * you select m2.2xlarge as the desired instance type.
         */
        fun desiredPartitionCount(desiredPartitionCount: Int): FluentBuilder
        /**
         * The number of replicas you want to preconfigure for each index partition.
         */
        fun desiredReplicationCount(desiredReplicationCount: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The instance type that you want to preconfigure for your domain. For example, search.m1.small.
         */
        var desiredInstanceType: PartitionInstanceType?
        /**
         * The number of partitions you want to preconfigure for your domain. Only valid when
         * you select m2.2xlarge as the desired instance type.
         */
        var desiredPartitionCount: Int
        /**
         * The number of replicas you want to preconfigure for each index partition.
         */
        var desiredReplicationCount: Int

        fun build(): ScalingParameters
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var desiredInstanceType: PartitionInstanceType? = null
        override var desiredPartitionCount: Int = 0
        override var desiredReplicationCount: Int = 0

        constructor(x: ScalingParameters) : this() {
            this.desiredInstanceType = x.desiredInstanceType
            this.desiredPartitionCount = x.desiredPartitionCount
            this.desiredReplicationCount = x.desiredReplicationCount
        }

        override fun build(): ScalingParameters = ScalingParameters(this)
        override fun desiredInstanceType(desiredInstanceType: PartitionInstanceType): FluentBuilder = apply { this.desiredInstanceType = desiredInstanceType }
        override fun desiredPartitionCount(desiredPartitionCount: Int): FluentBuilder = apply { this.desiredPartitionCount = desiredPartitionCount }
        override fun desiredReplicationCount(desiredReplicationCount: Int): FluentBuilder = apply { this.desiredReplicationCount = desiredReplicationCount }
    }
}
