// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The status of domain configuration option.
 */
class OptionStatus private constructor(builder: BuilderImpl) {
    /**
     * A timestamp for when this option was created.
     */
    val creationDate: Instant? = builder.creationDate
    /**
     * Indicates that the option will be deleted once processing is complete.
     */
    val pendingDeletion: Boolean? = builder.pendingDeletion
    /**
     * The state of processing a change to an option.  Possible values:
     * RequiresIndexDocuments: the option's latest value will not be deployed until  IndexDocuments has been called and indexing is complete.
     * Processing: the option's latest value is in the process of being activated.
     * Active: the option's latest value is completely deployed.
     * FailedToValidate: the option value is not compatible with the domain's data and cannot be used to index the data. You must either modify the option value or update or remove the incompatible documents.
     */
    val state: OptionState? = builder.state
    /**
     * A timestamp for when this option was last updated.
     */
    val updateDate: Instant? = builder.updateDate
    /**
     * A unique integer that indicates when this option was last updated.
     */
    val updateVersion: Int = builder.updateVersion

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): OptionStatus = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("OptionStatus(")
        append("creationDate=$creationDate,")
        append("pendingDeletion=$pendingDeletion,")
        append("state=$state,")
        append("updateDate=$updateDate,")
        append("updateVersion=$updateVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate?.hashCode() ?: 0
        result = 31 * result + (pendingDeletion?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (updateDate?.hashCode() ?: 0)
        result = 31 * result + (updateVersion)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OptionStatus

        if (creationDate != other.creationDate) return false
        if (pendingDeletion != other.pendingDeletion) return false
        if (state != other.state) return false
        if (updateDate != other.updateDate) return false
        if (updateVersion != other.updateVersion) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): OptionStatus = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): OptionStatus
        /**
         * A timestamp for when this option was created.
         */
        fun creationDate(creationDate: Instant): FluentBuilder
        /**
         * Indicates that the option will be deleted once processing is complete.
         */
        fun pendingDeletion(pendingDeletion: Boolean): FluentBuilder
        /**
         * The state of processing a change to an option.  Possible values:
         * RequiresIndexDocuments: the option's latest value will not be deployed until  IndexDocuments has been called and indexing is complete.
         * Processing: the option's latest value is in the process of being activated.
         * Active: the option's latest value is completely deployed.
         * FailedToValidate: the option value is not compatible with the domain's data and cannot be used to index the data. You must either modify the option value or update or remove the incompatible documents.
         */
        fun state(state: OptionState): FluentBuilder
        /**
         * A timestamp for when this option was last updated.
         */
        fun updateDate(updateDate: Instant): FluentBuilder
        /**
         * A unique integer that indicates when this option was last updated.
         */
        fun updateVersion(updateVersion: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A timestamp for when this option was created.
         */
        var creationDate: Instant?
        /**
         * Indicates that the option will be deleted once processing is complete.
         */
        var pendingDeletion: Boolean?
        /**
         * The state of processing a change to an option.  Possible values:
         * RequiresIndexDocuments: the option's latest value will not be deployed until  IndexDocuments has been called and indexing is complete.
         * Processing: the option's latest value is in the process of being activated.
         * Active: the option's latest value is completely deployed.
         * FailedToValidate: the option value is not compatible with the domain's data and cannot be used to index the data. You must either modify the option value or update or remove the incompatible documents.
         */
        var state: OptionState?
        /**
         * A timestamp for when this option was last updated.
         */
        var updateDate: Instant?
        /**
         * A unique integer that indicates when this option was last updated.
         */
        var updateVersion: Int

        fun build(): OptionStatus
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var creationDate: Instant? = null
        override var pendingDeletion: Boolean? = null
        override var state: OptionState? = null
        override var updateDate: Instant? = null
        override var updateVersion: Int = 0

        constructor(x: OptionStatus) : this() {
            this.creationDate = x.creationDate
            this.pendingDeletion = x.pendingDeletion
            this.state = x.state
            this.updateDate = x.updateDate
            this.updateVersion = x.updateVersion
        }

        override fun build(): OptionStatus = OptionStatus(this)
        override fun creationDate(creationDate: Instant): FluentBuilder = apply { this.creationDate = creationDate }
        override fun pendingDeletion(pendingDeletion: Boolean): FluentBuilder = apply { this.pendingDeletion = pendingDeletion }
        override fun state(state: OptionState): FluentBuilder = apply { this.state = state }
        override fun updateDate(updateDate: Instant): FluentBuilder = apply { this.updateDate = updateDate }
        override fun updateVersion(updateVersion: Int): FluentBuilder = apply { this.updateVersion = updateVersion }
    }
}
