// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * Options for a latlon field. A latlon field contains a location stored as a latitude and longitude value pair. Present if IndexFieldType specifies the field is of type latlon. All options are enabled by default.
 */
class LatLonOptions private constructor(builder: BuilderImpl) {
    /**
     * A value to use for the field if the field isn't specified for a document.
     */
    val defaultValue: String? = builder.defaultValue
    /**
     * Whether facet information can be returned for the field.
     */
    val facetEnabled: Boolean? = builder.facetEnabled
    /**
     * Whether the contents of the field can be returned in the search results.
     */
    val returnEnabled: Boolean? = builder.returnEnabled
    /**
     * Whether the contents of the field are searchable.
     */
    val searchEnabled: Boolean? = builder.searchEnabled
    /**
     * Whether the field can be used to sort the search results.
     */
    val sortEnabled: Boolean? = builder.sortEnabled
    /**
     * A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
     * A dynamic field's name defines a pattern that begins or ends with a wildcard.
     * Any document fields that don't map to a regular index field but do match a
     * dynamic field's pattern are configured with the dynamic field's indexing options.
     * Regular field names begin with a letter and can contain the following characters:
     * a-z (lowercase), 0-9, and _ (underscore).
     * Dynamic field names must begin or end with a wildcard (*).
     * The wildcard can also be the only character in a dynamic field name.
     * Multiple wildcards, and wildcards embedded within a string are not supported.
     * The name score is reserved and cannot be used as a field name.
     * To reference a document's ID, you can use the name _id.
     */
    val sourceField: String? = builder.sourceField

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LatLonOptions = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LatLonOptions(")
        append("defaultValue=$defaultValue,")
        append("facetEnabled=$facetEnabled,")
        append("returnEnabled=$returnEnabled,")
        append("searchEnabled=$searchEnabled,")
        append("sortEnabled=$sortEnabled,")
        append("sourceField=$sourceField)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultValue?.hashCode() ?: 0
        result = 31 * result + (facetEnabled?.hashCode() ?: 0)
        result = 31 * result + (returnEnabled?.hashCode() ?: 0)
        result = 31 * result + (searchEnabled?.hashCode() ?: 0)
        result = 31 * result + (sortEnabled?.hashCode() ?: 0)
        result = 31 * result + (sourceField?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LatLonOptions

        if (defaultValue != other.defaultValue) return false
        if (facetEnabled != other.facetEnabled) return false
        if (returnEnabled != other.returnEnabled) return false
        if (searchEnabled != other.searchEnabled) return false
        if (sortEnabled != other.sortEnabled) return false
        if (sourceField != other.sourceField) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LatLonOptions = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LatLonOptions
        /**
         * A value to use for the field if the field isn't specified for a document.
         */
        fun defaultValue(defaultValue: String): FluentBuilder
        /**
         * Whether facet information can be returned for the field.
         */
        fun facetEnabled(facetEnabled: Boolean): FluentBuilder
        /**
         * Whether the contents of the field can be returned in the search results.
         */
        fun returnEnabled(returnEnabled: Boolean): FluentBuilder
        /**
         * Whether the contents of the field are searchable.
         */
        fun searchEnabled(searchEnabled: Boolean): FluentBuilder
        /**
         * Whether the field can be used to sort the search results.
         */
        fun sortEnabled(sortEnabled: Boolean): FluentBuilder
        /**
         * A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
         * A dynamic field's name defines a pattern that begins or ends with a wildcard.
         * Any document fields that don't map to a regular index field but do match a
         * dynamic field's pattern are configured with the dynamic field's indexing options.
         * Regular field names begin with a letter and can contain the following characters:
         * a-z (lowercase), 0-9, and _ (underscore).
         * Dynamic field names must begin or end with a wildcard (*).
         * The wildcard can also be the only character in a dynamic field name.
         * Multiple wildcards, and wildcards embedded within a string are not supported.
         * The name score is reserved and cannot be used as a field name.
         * To reference a document's ID, you can use the name _id.
         */
        fun sourceField(sourceField: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A value to use for the field if the field isn't specified for a document.
         */
        var defaultValue: String?
        /**
         * Whether facet information can be returned for the field.
         */
        var facetEnabled: Boolean?
        /**
         * Whether the contents of the field can be returned in the search results.
         */
        var returnEnabled: Boolean?
        /**
         * Whether the contents of the field are searchable.
         */
        var searchEnabled: Boolean?
        /**
         * Whether the field can be used to sort the search results.
         */
        var sortEnabled: Boolean?
        /**
         * A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
         * A dynamic field's name defines a pattern that begins or ends with a wildcard.
         * Any document fields that don't map to a regular index field but do match a
         * dynamic field's pattern are configured with the dynamic field's indexing options.
         * Regular field names begin with a letter and can contain the following characters:
         * a-z (lowercase), 0-9, and _ (underscore).
         * Dynamic field names must begin or end with a wildcard (*).
         * The wildcard can also be the only character in a dynamic field name.
         * Multiple wildcards, and wildcards embedded within a string are not supported.
         * The name score is reserved and cannot be used as a field name.
         * To reference a document's ID, you can use the name _id.
         */
        var sourceField: String?

        fun build(): LatLonOptions
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var defaultValue: String? = null
        override var facetEnabled: Boolean? = null
        override var returnEnabled: Boolean? = null
        override var searchEnabled: Boolean? = null
        override var sortEnabled: Boolean? = null
        override var sourceField: String? = null

        constructor(x: LatLonOptions) : this() {
            this.defaultValue = x.defaultValue
            this.facetEnabled = x.facetEnabled
            this.returnEnabled = x.returnEnabled
            this.searchEnabled = x.searchEnabled
            this.sortEnabled = x.sortEnabled
            this.sourceField = x.sourceField
        }

        override fun build(): LatLonOptions = LatLonOptions(this)
        override fun defaultValue(defaultValue: String): FluentBuilder = apply { this.defaultValue = defaultValue }
        override fun facetEnabled(facetEnabled: Boolean): FluentBuilder = apply { this.facetEnabled = facetEnabled }
        override fun returnEnabled(returnEnabled: Boolean): FluentBuilder = apply { this.returnEnabled = returnEnabled }
        override fun searchEnabled(searchEnabled: Boolean): FluentBuilder = apply { this.searchEnabled = searchEnabled }
        override fun sortEnabled(sortEnabled: Boolean): FluentBuilder = apply { this.sortEnabled = sortEnabled }
        override fun sourceField(sourceField: String): FluentBuilder = apply { this.sourceField = sourceField }
    }
}
