// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * Configuration information for a field in the index, including its name, type, and options. The supported options depend on the IndexFieldType.
 */
class IndexField private constructor(builder: BuilderImpl) {
    /**
     * Options for a field that contains an array of dates.  Present if IndexFieldType specifies the field is of type date-array. All options are enabled by default.
     */
    val dateArrayOptions: DateArrayOptions? = builder.dateArrayOptions
    /**
     * Options for a date field. Dates and times are specified in UTC (Coordinated Universal Time) according to IETF RFC3339: yyyy-mm-ddT00:00:00Z.  Present if IndexFieldType specifies the field is of type date. All options are enabled by default.
     */
    val dateOptions: DateOptions? = builder.dateOptions
    /**
     * Options for a field that contains an array of double-precision 64-bit floating point values.  Present if IndexFieldType specifies the field is of type double-array.  All options are enabled by default.
     */
    val doubleArrayOptions: DoubleArrayOptions? = builder.doubleArrayOptions
    /**
     * Options for a double-precision 64-bit floating point field.  Present if IndexFieldType specifies the field is of type double. All options are enabled by default.
     */
    val doubleOptions: DoubleOptions? = builder.doubleOptions
    /**
     * A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
     * A dynamic field's name defines a pattern that begins or ends with a wildcard.
     * Any document fields that don't map to a regular index field but do match a
     * dynamic field's pattern are configured with the dynamic field's indexing options.
     * Regular field names begin with a letter and can contain the following characters:
     * a-z (lowercase), 0-9, and _ (underscore).
     * Dynamic field names must begin or end with a wildcard (*).
     * The wildcard can also be the only character in a dynamic field name.
     * Multiple wildcards, and wildcards embedded within a string are not supported.
     * The name score is reserved and cannot be used as a field name.
     * To reference a document's ID, you can use the name _id.
     */
    val indexFieldName: String? = builder.indexFieldName
    /**
     * The type of field. The valid options for a field depend on the field type. For more information about the supported field types, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html" target="_blank">Configuring Index Fields in the Amazon CloudSearch Developer Guide.
     */
    val indexFieldType: IndexFieldType? = builder.indexFieldType
    /**
     * Options for a field that contains an array of 64-bit signed integers.  Present if IndexFieldType specifies the field is of type int-array. All options are enabled by default.
     */
    val intArrayOptions: IntArrayOptions? = builder.intArrayOptions
    /**
     * Options for a 64-bit signed integer field.  Present if IndexFieldType specifies the field is of type int. All options are enabled by default.
     */
    val intOptions: IntOptions? = builder.intOptions
    /**
     * Options for a latlon field. A latlon field contains a location stored as a latitude and longitude value pair. Present if IndexFieldType specifies the field is of type latlon. All options are enabled by default.
     */
    val latLonOptions: LatLonOptions? = builder.latLonOptions
    /**
     * Options for a field that contains an array of literal strings.  Present if IndexFieldType specifies the field is of type literal-array. All options are enabled by default.
     */
    val literalArrayOptions: LiteralArrayOptions? = builder.literalArrayOptions
    /**
     * Options for literal field.  Present if IndexFieldType specifies the field is of type literal. All options are enabled by default.
     */
    val literalOptions: LiteralOptions? = builder.literalOptions
    /**
     * Options for a field that contains an array of text strings.  Present if IndexFieldType specifies the field is of type text-array. A text-array field is always searchable. All options are enabled by default.
     */
    val textArrayOptions: TextArrayOptions? = builder.textArrayOptions
    /**
     * Options for text field.  Present if IndexFieldType specifies the field is of type text. A text field is always searchable. All options are enabled by default.
     */
    val textOptions: TextOptions? = builder.textOptions

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): IndexField = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("IndexField(")
        append("dateArrayOptions=$dateArrayOptions,")
        append("dateOptions=$dateOptions,")
        append("doubleArrayOptions=$doubleArrayOptions,")
        append("doubleOptions=$doubleOptions,")
        append("indexFieldName=$indexFieldName,")
        append("indexFieldType=$indexFieldType,")
        append("intArrayOptions=$intArrayOptions,")
        append("intOptions=$intOptions,")
        append("latLonOptions=$latLonOptions,")
        append("literalArrayOptions=$literalArrayOptions,")
        append("literalOptions=$literalOptions,")
        append("textArrayOptions=$textArrayOptions,")
        append("textOptions=$textOptions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dateArrayOptions?.hashCode() ?: 0
        result = 31 * result + (dateOptions?.hashCode() ?: 0)
        result = 31 * result + (doubleArrayOptions?.hashCode() ?: 0)
        result = 31 * result + (doubleOptions?.hashCode() ?: 0)
        result = 31 * result + (indexFieldName?.hashCode() ?: 0)
        result = 31 * result + (indexFieldType?.hashCode() ?: 0)
        result = 31 * result + (intArrayOptions?.hashCode() ?: 0)
        result = 31 * result + (intOptions?.hashCode() ?: 0)
        result = 31 * result + (latLonOptions?.hashCode() ?: 0)
        result = 31 * result + (literalArrayOptions?.hashCode() ?: 0)
        result = 31 * result + (literalOptions?.hashCode() ?: 0)
        result = 31 * result + (textArrayOptions?.hashCode() ?: 0)
        result = 31 * result + (textOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as IndexField

        if (dateArrayOptions != other.dateArrayOptions) return false
        if (dateOptions != other.dateOptions) return false
        if (doubleArrayOptions != other.doubleArrayOptions) return false
        if (doubleOptions != other.doubleOptions) return false
        if (indexFieldName != other.indexFieldName) return false
        if (indexFieldType != other.indexFieldType) return false
        if (intArrayOptions != other.intArrayOptions) return false
        if (intOptions != other.intOptions) return false
        if (latLonOptions != other.latLonOptions) return false
        if (literalArrayOptions != other.literalArrayOptions) return false
        if (literalOptions != other.literalOptions) return false
        if (textArrayOptions != other.textArrayOptions) return false
        if (textOptions != other.textOptions) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): IndexField = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): IndexField
        /**
         * Options for a field that contains an array of dates.  Present if IndexFieldType specifies the field is of type date-array. All options are enabled by default.
         */
        fun dateArrayOptions(dateArrayOptions: DateArrayOptions): FluentBuilder
        /**
         * Options for a date field. Dates and times are specified in UTC (Coordinated Universal Time) according to IETF RFC3339: yyyy-mm-ddT00:00:00Z.  Present if IndexFieldType specifies the field is of type date. All options are enabled by default.
         */
        fun dateOptions(dateOptions: DateOptions): FluentBuilder
        /**
         * Options for a field that contains an array of double-precision 64-bit floating point values.  Present if IndexFieldType specifies the field is of type double-array.  All options are enabled by default.
         */
        fun doubleArrayOptions(doubleArrayOptions: DoubleArrayOptions): FluentBuilder
        /**
         * Options for a double-precision 64-bit floating point field.  Present if IndexFieldType specifies the field is of type double. All options are enabled by default.
         */
        fun doubleOptions(doubleOptions: DoubleOptions): FluentBuilder
        /**
         * A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
         * A dynamic field's name defines a pattern that begins or ends with a wildcard.
         * Any document fields that don't map to a regular index field but do match a
         * dynamic field's pattern are configured with the dynamic field's indexing options.
         * Regular field names begin with a letter and can contain the following characters:
         * a-z (lowercase), 0-9, and _ (underscore).
         * Dynamic field names must begin or end with a wildcard (*).
         * The wildcard can also be the only character in a dynamic field name.
         * Multiple wildcards, and wildcards embedded within a string are not supported.
         * The name score is reserved and cannot be used as a field name.
         * To reference a document's ID, you can use the name _id.
         */
        fun indexFieldName(indexFieldName: String): FluentBuilder
        /**
         * The type of field. The valid options for a field depend on the field type. For more information about the supported field types, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html" target="_blank">Configuring Index Fields in the Amazon CloudSearch Developer Guide.
         */
        fun indexFieldType(indexFieldType: IndexFieldType): FluentBuilder
        /**
         * Options for a field that contains an array of 64-bit signed integers.  Present if IndexFieldType specifies the field is of type int-array. All options are enabled by default.
         */
        fun intArrayOptions(intArrayOptions: IntArrayOptions): FluentBuilder
        /**
         * Options for a 64-bit signed integer field.  Present if IndexFieldType specifies the field is of type int. All options are enabled by default.
         */
        fun intOptions(intOptions: IntOptions): FluentBuilder
        /**
         * Options for a latlon field. A latlon field contains a location stored as a latitude and longitude value pair. Present if IndexFieldType specifies the field is of type latlon. All options are enabled by default.
         */
        fun latLonOptions(latLonOptions: LatLonOptions): FluentBuilder
        /**
         * Options for a field that contains an array of literal strings.  Present if IndexFieldType specifies the field is of type literal-array. All options are enabled by default.
         */
        fun literalArrayOptions(literalArrayOptions: LiteralArrayOptions): FluentBuilder
        /**
         * Options for literal field.  Present if IndexFieldType specifies the field is of type literal. All options are enabled by default.
         */
        fun literalOptions(literalOptions: LiteralOptions): FluentBuilder
        /**
         * Options for a field that contains an array of text strings.  Present if IndexFieldType specifies the field is of type text-array. A text-array field is always searchable. All options are enabled by default.
         */
        fun textArrayOptions(textArrayOptions: TextArrayOptions): FluentBuilder
        /**
         * Options for text field.  Present if IndexFieldType specifies the field is of type text. A text field is always searchable. All options are enabled by default.
         */
        fun textOptions(textOptions: TextOptions): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Options for a field that contains an array of dates.  Present if IndexFieldType specifies the field is of type date-array. All options are enabled by default.
         */
        var dateArrayOptions: DateArrayOptions?
        /**
         * Options for a date field. Dates and times are specified in UTC (Coordinated Universal Time) according to IETF RFC3339: yyyy-mm-ddT00:00:00Z.  Present if IndexFieldType specifies the field is of type date. All options are enabled by default.
         */
        var dateOptions: DateOptions?
        /**
         * Options for a field that contains an array of double-precision 64-bit floating point values.  Present if IndexFieldType specifies the field is of type double-array.  All options are enabled by default.
         */
        var doubleArrayOptions: DoubleArrayOptions?
        /**
         * Options for a double-precision 64-bit floating point field.  Present if IndexFieldType specifies the field is of type double. All options are enabled by default.
         */
        var doubleOptions: DoubleOptions?
        /**
         * A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
         * A dynamic field's name defines a pattern that begins or ends with a wildcard.
         * Any document fields that don't map to a regular index field but do match a
         * dynamic field's pattern are configured with the dynamic field's indexing options.
         * Regular field names begin with a letter and can contain the following characters:
         * a-z (lowercase), 0-9, and _ (underscore).
         * Dynamic field names must begin or end with a wildcard (*).
         * The wildcard can also be the only character in a dynamic field name.
         * Multiple wildcards, and wildcards embedded within a string are not supported.
         * The name score is reserved and cannot be used as a field name.
         * To reference a document's ID, you can use the name _id.
         */
        var indexFieldName: String?
        /**
         * The type of field. The valid options for a field depend on the field type. For more information about the supported field types, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html" target="_blank">Configuring Index Fields in the Amazon CloudSearch Developer Guide.
         */
        var indexFieldType: IndexFieldType?
        /**
         * Options for a field that contains an array of 64-bit signed integers.  Present if IndexFieldType specifies the field is of type int-array. All options are enabled by default.
         */
        var intArrayOptions: IntArrayOptions?
        /**
         * Options for a 64-bit signed integer field.  Present if IndexFieldType specifies the field is of type int. All options are enabled by default.
         */
        var intOptions: IntOptions?
        /**
         * Options for a latlon field. A latlon field contains a location stored as a latitude and longitude value pair. Present if IndexFieldType specifies the field is of type latlon. All options are enabled by default.
         */
        var latLonOptions: LatLonOptions?
        /**
         * Options for a field that contains an array of literal strings.  Present if IndexFieldType specifies the field is of type literal-array. All options are enabled by default.
         */
        var literalArrayOptions: LiteralArrayOptions?
        /**
         * Options for literal field.  Present if IndexFieldType specifies the field is of type literal. All options are enabled by default.
         */
        var literalOptions: LiteralOptions?
        /**
         * Options for a field that contains an array of text strings.  Present if IndexFieldType specifies the field is of type text-array. A text-array field is always searchable. All options are enabled by default.
         */
        var textArrayOptions: TextArrayOptions?
        /**
         * Options for text field.  Present if IndexFieldType specifies the field is of type text. A text field is always searchable. All options are enabled by default.
         */
        var textOptions: TextOptions?

        fun build(): IndexField
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.DateArrayOptions] inside the given [block]
         */
        fun dateArrayOptions(block: DateArrayOptions.DslBuilder.() -> kotlin.Unit) {
            this.dateArrayOptions = DateArrayOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.DateOptions] inside the given [block]
         */
        fun dateOptions(block: DateOptions.DslBuilder.() -> kotlin.Unit) {
            this.dateOptions = DateOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.DoubleArrayOptions] inside the given [block]
         */
        fun doubleArrayOptions(block: DoubleArrayOptions.DslBuilder.() -> kotlin.Unit) {
            this.doubleArrayOptions = DoubleArrayOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.DoubleOptions] inside the given [block]
         */
        fun doubleOptions(block: DoubleOptions.DslBuilder.() -> kotlin.Unit) {
            this.doubleOptions = DoubleOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.IntArrayOptions] inside the given [block]
         */
        fun intArrayOptions(block: IntArrayOptions.DslBuilder.() -> kotlin.Unit) {
            this.intArrayOptions = IntArrayOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.IntOptions] inside the given [block]
         */
        fun intOptions(block: IntOptions.DslBuilder.() -> kotlin.Unit) {
            this.intOptions = IntOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.LatLonOptions] inside the given [block]
         */
        fun latLonOptions(block: LatLonOptions.DslBuilder.() -> kotlin.Unit) {
            this.latLonOptions = LatLonOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.LiteralArrayOptions] inside the given [block]
         */
        fun literalArrayOptions(block: LiteralArrayOptions.DslBuilder.() -> kotlin.Unit) {
            this.literalArrayOptions = LiteralArrayOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.LiteralOptions] inside the given [block]
         */
        fun literalOptions(block: LiteralOptions.DslBuilder.() -> kotlin.Unit) {
            this.literalOptions = LiteralOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.TextArrayOptions] inside the given [block]
         */
        fun textArrayOptions(block: TextArrayOptions.DslBuilder.() -> kotlin.Unit) {
            this.textArrayOptions = TextArrayOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.TextOptions] inside the given [block]
         */
        fun textOptions(block: TextOptions.DslBuilder.() -> kotlin.Unit) {
            this.textOptions = TextOptions.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dateArrayOptions: DateArrayOptions? = null
        override var dateOptions: DateOptions? = null
        override var doubleArrayOptions: DoubleArrayOptions? = null
        override var doubleOptions: DoubleOptions? = null
        override var indexFieldName: String? = null
        override var indexFieldType: IndexFieldType? = null
        override var intArrayOptions: IntArrayOptions? = null
        override var intOptions: IntOptions? = null
        override var latLonOptions: LatLonOptions? = null
        override var literalArrayOptions: LiteralArrayOptions? = null
        override var literalOptions: LiteralOptions? = null
        override var textArrayOptions: TextArrayOptions? = null
        override var textOptions: TextOptions? = null

        constructor(x: IndexField) : this() {
            this.dateArrayOptions = x.dateArrayOptions
            this.dateOptions = x.dateOptions
            this.doubleArrayOptions = x.doubleArrayOptions
            this.doubleOptions = x.doubleOptions
            this.indexFieldName = x.indexFieldName
            this.indexFieldType = x.indexFieldType
            this.intArrayOptions = x.intArrayOptions
            this.intOptions = x.intOptions
            this.latLonOptions = x.latLonOptions
            this.literalArrayOptions = x.literalArrayOptions
            this.literalOptions = x.literalOptions
            this.textArrayOptions = x.textArrayOptions
            this.textOptions = x.textOptions
        }

        override fun build(): IndexField = IndexField(this)
        override fun dateArrayOptions(dateArrayOptions: DateArrayOptions): FluentBuilder = apply { this.dateArrayOptions = dateArrayOptions }
        override fun dateOptions(dateOptions: DateOptions): FluentBuilder = apply { this.dateOptions = dateOptions }
        override fun doubleArrayOptions(doubleArrayOptions: DoubleArrayOptions): FluentBuilder = apply { this.doubleArrayOptions = doubleArrayOptions }
        override fun doubleOptions(doubleOptions: DoubleOptions): FluentBuilder = apply { this.doubleOptions = doubleOptions }
        override fun indexFieldName(indexFieldName: String): FluentBuilder = apply { this.indexFieldName = indexFieldName }
        override fun indexFieldType(indexFieldType: IndexFieldType): FluentBuilder = apply { this.indexFieldType = indexFieldType }
        override fun intArrayOptions(intArrayOptions: IntArrayOptions): FluentBuilder = apply { this.intArrayOptions = intArrayOptions }
        override fun intOptions(intOptions: IntOptions): FluentBuilder = apply { this.intOptions = intOptions }
        override fun latLonOptions(latLonOptions: LatLonOptions): FluentBuilder = apply { this.latLonOptions = latLonOptions }
        override fun literalArrayOptions(literalArrayOptions: LiteralArrayOptions): FluentBuilder = apply { this.literalArrayOptions = literalArrayOptions }
        override fun literalOptions(literalOptions: LiteralOptions): FluentBuilder = apply { this.literalOptions = literalOptions }
        override fun textArrayOptions(textArrayOptions: TextArrayOptions): FluentBuilder = apply { this.textArrayOptions = textArrayOptions }
        override fun textOptions(textOptions: TextOptions): FluentBuilder = apply { this.textOptions = textOptions }
    }
}
