// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * A named expression that can be evaluated at search time. Can be used to sort the search results, define other expressions, or return computed information in the search results.
 */
class Expression private constructor(builder: BuilderImpl) {
    /**
     * Names must begin with a letter and can contain the following characters:
     * a-z (lowercase), 0-9, and _ (underscore).
     */
    val expressionName: String? = builder.expressionName
    /**
     * The expression to evaluate for sorting while processing a search request.  The Expression syntax is based on JavaScript expressions. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions in the Amazon CloudSearch Developer Guide.
     */
    val expressionValue: String? = builder.expressionValue

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Expression = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Expression(")
        append("expressionName=$expressionName,")
        append("expressionValue=$expressionValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = expressionName?.hashCode() ?: 0
        result = 31 * result + (expressionValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Expression

        if (expressionName != other.expressionName) return false
        if (expressionValue != other.expressionValue) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Expression = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Expression
        /**
         * Names must begin with a letter and can contain the following characters:
         * a-z (lowercase), 0-9, and _ (underscore).
         */
        fun expressionName(expressionName: String): FluentBuilder
        /**
         * The expression to evaluate for sorting while processing a search request.  The Expression syntax is based on JavaScript expressions. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions in the Amazon CloudSearch Developer Guide.
         */
        fun expressionValue(expressionValue: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Names must begin with a letter and can contain the following characters:
         * a-z (lowercase), 0-9, and _ (underscore).
         */
        var expressionName: String?
        /**
         * The expression to evaluate for sorting while processing a search request.  The Expression syntax is based on JavaScript expressions. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions in the Amazon CloudSearch Developer Guide.
         */
        var expressionValue: String?

        fun build(): Expression
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var expressionName: String? = null
        override var expressionValue: String? = null

        constructor(x: Expression) : this() {
            this.expressionName = x.expressionName
            this.expressionValue = x.expressionValue
        }

        override fun build(): Expression = Expression(this)
        override fun expressionName(expressionName: String): FluentBuilder = apply { this.expressionName = expressionName }
        override fun expressionValue(expressionValue: String): FluentBuilder = apply { this.expressionValue = expressionValue }
    }
}
