// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * The current status of the search domain.
 */
class DomainStatus private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the search domain.  See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html" target="_blank">Identifiers for IAM Entities in Using AWS Identity and Access Management for more information.
     */
    val arn: String? = builder.arn
    /**
     * True if the search domain is created. It can take several minutes to initialize a domain when CreateDomain is called. Newly created search domains are returned from DescribeDomains with a false value for Created until domain creation is complete.
     */
    val created: Boolean? = builder.created
    /**
     * True if the search domain has been deleted.  The system must clean up resources dedicated to the search domain when DeleteDomain is called.  Newly deleted search domains are returned from DescribeDomains with a true value for IsDeleted for several minutes until resource cleanup is complete.
     */
    val deleted: Boolean? = builder.deleted
    /**
     * The service endpoint for updating documents in a search domain.
     */
    val docService: ServiceEndpoint? = builder.docService
    /**
     * An internally generated unique identifier for a domain.
     */
    val domainId: String? = builder.domainId
    /**
     * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
     */
    val domainName: String? = builder.domainName
    val limits: Limits? = builder.limits
    /**
     * True if processing is being done to activate the current domain configuration.
     */
    val processing: Boolean? = builder.processing
    /**
     * True if IndexDocuments needs to be called to activate the current domain configuration.
     */
    val requiresIndexDocuments: Boolean? = builder.requiresIndexDocuments
    /**
     * The number of search instances that are available to process search requests.
     */
    val searchInstanceCount: Int = builder.searchInstanceCount
    /**
     * The instance type that is being used to process search requests.
     */
    val searchInstanceType: String? = builder.searchInstanceType
    /**
     * The number of partitions across which the search index is spread.
     */
    val searchPartitionCount: Int = builder.searchPartitionCount
    /**
     * The service endpoint for requesting search results from a search domain.
     */
    val searchService: ServiceEndpoint? = builder.searchService

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DomainStatus = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DomainStatus(")
        append("arn=$arn,")
        append("created=$created,")
        append("deleted=$deleted,")
        append("docService=$docService,")
        append("domainId=$domainId,")
        append("domainName=$domainName,")
        append("limits=$limits,")
        append("processing=$processing,")
        append("requiresIndexDocuments=$requiresIndexDocuments,")
        append("searchInstanceCount=$searchInstanceCount,")
        append("searchInstanceType=$searchInstanceType,")
        append("searchPartitionCount=$searchPartitionCount,")
        append("searchService=$searchService)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (deleted?.hashCode() ?: 0)
        result = 31 * result + (docService?.hashCode() ?: 0)
        result = 31 * result + (domainId?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (limits?.hashCode() ?: 0)
        result = 31 * result + (processing?.hashCode() ?: 0)
        result = 31 * result + (requiresIndexDocuments?.hashCode() ?: 0)
        result = 31 * result + (searchInstanceCount)
        result = 31 * result + (searchInstanceType?.hashCode() ?: 0)
        result = 31 * result + (searchPartitionCount)
        result = 31 * result + (searchService?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DomainStatus

        if (arn != other.arn) return false
        if (created != other.created) return false
        if (deleted != other.deleted) return false
        if (docService != other.docService) return false
        if (domainId != other.domainId) return false
        if (domainName != other.domainName) return false
        if (limits != other.limits) return false
        if (processing != other.processing) return false
        if (requiresIndexDocuments != other.requiresIndexDocuments) return false
        if (searchInstanceCount != other.searchInstanceCount) return false
        if (searchInstanceType != other.searchInstanceType) return false
        if (searchPartitionCount != other.searchPartitionCount) return false
        if (searchService != other.searchService) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DomainStatus = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DomainStatus
        /**
         * The Amazon Resource Name (ARN) of the search domain.  See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html" target="_blank">Identifiers for IAM Entities in Using AWS Identity and Access Management for more information.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * True if the search domain is created. It can take several minutes to initialize a domain when CreateDomain is called. Newly created search domains are returned from DescribeDomains with a false value for Created until domain creation is complete.
         */
        fun created(created: Boolean): FluentBuilder
        /**
         * True if the search domain has been deleted.  The system must clean up resources dedicated to the search domain when DeleteDomain is called.  Newly deleted search domains are returned from DescribeDomains with a true value for IsDeleted for several minutes until resource cleanup is complete.
         */
        fun deleted(deleted: Boolean): FluentBuilder
        /**
         * The service endpoint for updating documents in a search domain.
         */
        fun docService(docService: ServiceEndpoint): FluentBuilder
        /**
         * An internally generated unique identifier for a domain.
         */
        fun domainId(domainId: String): FluentBuilder
        /**
         * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        fun domainName(domainName: String): FluentBuilder
        fun limits(limits: Limits): FluentBuilder
        /**
         * True if processing is being done to activate the current domain configuration.
         */
        fun processing(processing: Boolean): FluentBuilder
        /**
         * True if IndexDocuments needs to be called to activate the current domain configuration.
         */
        fun requiresIndexDocuments(requiresIndexDocuments: Boolean): FluentBuilder
        /**
         * The number of search instances that are available to process search requests.
         */
        fun searchInstanceCount(searchInstanceCount: Int): FluentBuilder
        /**
         * The instance type that is being used to process search requests.
         */
        fun searchInstanceType(searchInstanceType: String): FluentBuilder
        /**
         * The number of partitions across which the search index is spread.
         */
        fun searchPartitionCount(searchPartitionCount: Int): FluentBuilder
        /**
         * The service endpoint for requesting search results from a search domain.
         */
        fun searchService(searchService: ServiceEndpoint): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the search domain.  See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html" target="_blank">Identifiers for IAM Entities in Using AWS Identity and Access Management for more information.
         */
        var arn: String?
        /**
         * True if the search domain is created. It can take several minutes to initialize a domain when CreateDomain is called. Newly created search domains are returned from DescribeDomains with a false value for Created until domain creation is complete.
         */
        var created: Boolean?
        /**
         * True if the search domain has been deleted.  The system must clean up resources dedicated to the search domain when DeleteDomain is called.  Newly deleted search domains are returned from DescribeDomains with a true value for IsDeleted for several minutes until resource cleanup is complete.
         */
        var deleted: Boolean?
        /**
         * The service endpoint for updating documents in a search domain.
         */
        var docService: ServiceEndpoint?
        /**
         * An internally generated unique identifier for a domain.
         */
        var domainId: String?
        /**
         * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        var domainName: String?
        var limits: Limits?
        /**
         * True if processing is being done to activate the current domain configuration.
         */
        var processing: Boolean?
        /**
         * True if IndexDocuments needs to be called to activate the current domain configuration.
         */
        var requiresIndexDocuments: Boolean?
        /**
         * The number of search instances that are available to process search requests.
         */
        var searchInstanceCount: Int
        /**
         * The instance type that is being used to process search requests.
         */
        var searchInstanceType: String?
        /**
         * The number of partitions across which the search index is spread.
         */
        var searchPartitionCount: Int
        /**
         * The service endpoint for requesting search results from a search domain.
         */
        var searchService: ServiceEndpoint?

        fun build(): DomainStatus
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.ServiceEndpoint] inside the given [block]
         */
        fun docService(block: ServiceEndpoint.DslBuilder.() -> kotlin.Unit) {
            this.docService = ServiceEndpoint.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.Limits] inside the given [block]
         */
        fun limits(block: Limits.DslBuilder.() -> kotlin.Unit) {
            this.limits = Limits.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.ServiceEndpoint] inside the given [block]
         */
        fun searchService(block: ServiceEndpoint.DslBuilder.() -> kotlin.Unit) {
            this.searchService = ServiceEndpoint.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var created: Boolean? = null
        override var deleted: Boolean? = null
        override var docService: ServiceEndpoint? = null
        override var domainId: String? = null
        override var domainName: String? = null
        override var limits: Limits? = null
        override var processing: Boolean? = null
        override var requiresIndexDocuments: Boolean? = null
        override var searchInstanceCount: Int = 0
        override var searchInstanceType: String? = null
        override var searchPartitionCount: Int = 0
        override var searchService: ServiceEndpoint? = null

        constructor(x: DomainStatus) : this() {
            this.arn = x.arn
            this.created = x.created
            this.deleted = x.deleted
            this.docService = x.docService
            this.domainId = x.domainId
            this.domainName = x.domainName
            this.limits = x.limits
            this.processing = x.processing
            this.requiresIndexDocuments = x.requiresIndexDocuments
            this.searchInstanceCount = x.searchInstanceCount
            this.searchInstanceType = x.searchInstanceType
            this.searchPartitionCount = x.searchPartitionCount
            this.searchService = x.searchService
        }

        override fun build(): DomainStatus = DomainStatus(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun created(created: Boolean): FluentBuilder = apply { this.created = created }
        override fun deleted(deleted: Boolean): FluentBuilder = apply { this.deleted = deleted }
        override fun docService(docService: ServiceEndpoint): FluentBuilder = apply { this.docService = docService }
        override fun domainId(domainId: String): FluentBuilder = apply { this.domainId = domainId }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun limits(limits: Limits): FluentBuilder = apply { this.limits = limits }
        override fun processing(processing: Boolean): FluentBuilder = apply { this.processing = processing }
        override fun requiresIndexDocuments(requiresIndexDocuments: Boolean): FluentBuilder = apply { this.requiresIndexDocuments = requiresIndexDocuments }
        override fun searchInstanceCount(searchInstanceCount: Int): FluentBuilder = apply { this.searchInstanceCount = searchInstanceCount }
        override fun searchInstanceType(searchInstanceType: String): FluentBuilder = apply { this.searchInstanceType = searchInstanceType }
        override fun searchPartitionCount(searchPartitionCount: Int): FluentBuilder = apply { this.searchPartitionCount = searchPartitionCount }
        override fun searchService(searchService: ServiceEndpoint): FluentBuilder = apply { this.searchService = searchService }
    }
}
