// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * Options for a search suggester.
 */
class DocumentSuggesterOptions private constructor(builder: BuilderImpl) {
    /**
     * The level of fuzziness allowed when suggesting matches for a string: none, low, or high. With none, the specified string is treated as an exact prefix. With low, suggestions must differ from the specified string by no more than one character. With high, suggestions can differ by up to two characters. The default is none.
     */
    val fuzzyMatching: SuggesterFuzzyMatching? = builder.fuzzyMatching
    /**
     * An expression that computes a score for each suggestion to control how they are sorted. The scores are rounded to the nearest
     * integer, with a floor of 0 and a ceiling of 2^31-1. A document's relevance score is not computed
     * for suggestions, so sort expressions cannot reference the _score value.
     * To sort suggestions using a numeric field or existing expression, simply specify
     * the name of the field or expression. If no expression is configured for the suggester, the
     * suggestions are sorted with the closest matches listed first.
     */
    val sortExpression: String? = builder.sortExpression
    /**
     * The name of the index field you want to use for suggestions.
     */
    val sourceField: String? = builder.sourceField

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DocumentSuggesterOptions = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentSuggesterOptions(")
        append("fuzzyMatching=$fuzzyMatching,")
        append("sortExpression=$sortExpression,")
        append("sourceField=$sourceField)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fuzzyMatching?.hashCode() ?: 0
        result = 31 * result + (sortExpression?.hashCode() ?: 0)
        result = 31 * result + (sourceField?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DocumentSuggesterOptions

        if (fuzzyMatching != other.fuzzyMatching) return false
        if (sortExpression != other.sortExpression) return false
        if (sourceField != other.sourceField) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DocumentSuggesterOptions = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DocumentSuggesterOptions
        /**
         * The level of fuzziness allowed when suggesting matches for a string: none, low, or high. With none, the specified string is treated as an exact prefix. With low, suggestions must differ from the specified string by no more than one character. With high, suggestions can differ by up to two characters. The default is none.
         */
        fun fuzzyMatching(fuzzyMatching: SuggesterFuzzyMatching): FluentBuilder
        /**
         * An expression that computes a score for each suggestion to control how they are sorted. The scores are rounded to the nearest
         * integer, with a floor of 0 and a ceiling of 2^31-1. A document's relevance score is not computed
         * for suggestions, so sort expressions cannot reference the _score value.
         * To sort suggestions using a numeric field or existing expression, simply specify
         * the name of the field or expression. If no expression is configured for the suggester, the
         * suggestions are sorted with the closest matches listed first.
         */
        fun sortExpression(sortExpression: String): FluentBuilder
        /**
         * The name of the index field you want to use for suggestions.
         */
        fun sourceField(sourceField: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The level of fuzziness allowed when suggesting matches for a string: none, low, or high. With none, the specified string is treated as an exact prefix. With low, suggestions must differ from the specified string by no more than one character. With high, suggestions can differ by up to two characters. The default is none.
         */
        var fuzzyMatching: SuggesterFuzzyMatching?
        /**
         * An expression that computes a score for each suggestion to control how they are sorted. The scores are rounded to the nearest
         * integer, with a floor of 0 and a ceiling of 2^31-1. A document's relevance score is not computed
         * for suggestions, so sort expressions cannot reference the _score value.
         * To sort suggestions using a numeric field or existing expression, simply specify
         * the name of the field or expression. If no expression is configured for the suggester, the
         * suggestions are sorted with the closest matches listed first.
         */
        var sortExpression: String?
        /**
         * The name of the index field you want to use for suggestions.
         */
        var sourceField: String?

        fun build(): DocumentSuggesterOptions
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var fuzzyMatching: SuggesterFuzzyMatching? = null
        override var sortExpression: String? = null
        override var sourceField: String? = null

        constructor(x: DocumentSuggesterOptions) : this() {
            this.fuzzyMatching = x.fuzzyMatching
            this.sortExpression = x.sortExpression
            this.sourceField = x.sourceField
        }

        override fun build(): DocumentSuggesterOptions = DocumentSuggesterOptions(this)
        override fun fuzzyMatching(fuzzyMatching: SuggesterFuzzyMatching): FluentBuilder = apply { this.fuzzyMatching = fuzzyMatching }
        override fun sortExpression(sortExpression: String): FluentBuilder = apply { this.sortExpression = sortExpression }
        override fun sourceField(sourceField: String): FluentBuilder = apply { this.sourceField = sourceField }
    }
}
