// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * Container for the parameters to the DescribeIndexFields operation. Specifies the name of the domain you want to describe. To restrict the response to particular index fields, specify the names of the index fields you want to describe. To show  the active configuration and exclude any pending changes, set the Deployed option to true.
 */
class DescribeIndexFieldsRequest private constructor(builder: BuilderImpl) {
    /**
     * Whether to display the deployed configuration (true) or include any pending changes (false). Defaults to false.
     */
    val deployed: Boolean? = builder.deployed
    /**
     * The name of the domain you want to describe.
     */
    val domainName: String? = builder.domainName
    /**
     * A list of the index fields you want to describe. If not specified, information is returned for all configured index fields.
     */
    val fieldNames: List<String>? = builder.fieldNames

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeIndexFieldsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeIndexFieldsRequest(")
        append("deployed=$deployed,")
        append("domainName=$domainName,")
        append("fieldNames=$fieldNames)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deployed?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (fieldNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeIndexFieldsRequest

        if (deployed != other.deployed) return false
        if (domainName != other.domainName) return false
        if (fieldNames != other.fieldNames) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeIndexFieldsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeIndexFieldsRequest
        /**
         * Whether to display the deployed configuration (true) or include any pending changes (false). Defaults to false.
         */
        fun deployed(deployed: Boolean): FluentBuilder
        /**
         * The name of the domain you want to describe.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * A list of the index fields you want to describe. If not specified, information is returned for all configured index fields.
         */
        fun fieldNames(fieldNames: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Whether to display the deployed configuration (true) or include any pending changes (false). Defaults to false.
         */
        var deployed: Boolean?
        /**
         * The name of the domain you want to describe.
         */
        var domainName: String?
        /**
         * A list of the index fields you want to describe. If not specified, information is returned for all configured index fields.
         */
        var fieldNames: List<String>?

        fun build(): DescribeIndexFieldsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deployed: Boolean? = null
        override var domainName: String? = null
        override var fieldNames: List<String>? = null

        constructor(x: DescribeIndexFieldsRequest) : this() {
            this.deployed = x.deployed
            this.domainName = x.domainName
            this.fieldNames = x.fieldNames
        }

        override fun build(): DescribeIndexFieldsRequest = DescribeIndexFieldsRequest(this)
        override fun deployed(deployed: Boolean): FluentBuilder = apply { this.deployed = deployed }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun fieldNames(fieldNames: List<String>): FluentBuilder = apply { this.fieldNames = fieldNames }
    }
}
