// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * Container for the parameters to the DescribeDomains operation.
 * Specifies the name of the domain you want to describe. To restrict the response to particular expressions, specify the names of the expressions you want to describe. To show the active configuration and exclude any pending changes, set the Deployed option to true.
 */
class DescribeExpressionsRequest private constructor(builder: BuilderImpl) {
    /**
     * Whether to display the deployed configuration (true) or include any pending changes (false). Defaults to false.
     */
    val deployed: Boolean? = builder.deployed
    /**
     * The name of the domain you want to describe.
     */
    val domainName: String? = builder.domainName
    /**
     * Limits the DescribeExpressions response to the specified expressions. If not specified, all expressions are shown.
     */
    val expressionNames: List<String>? = builder.expressionNames

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeExpressionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeExpressionsRequest(")
        append("deployed=$deployed,")
        append("domainName=$domainName,")
        append("expressionNames=$expressionNames)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deployed?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (expressionNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeExpressionsRequest

        if (deployed != other.deployed) return false
        if (domainName != other.domainName) return false
        if (expressionNames != other.expressionNames) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeExpressionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeExpressionsRequest
        /**
         * Whether to display the deployed configuration (true) or include any pending changes (false). Defaults to false.
         */
        fun deployed(deployed: Boolean): FluentBuilder
        /**
         * The name of the domain you want to describe.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * Limits the DescribeExpressions response to the specified expressions. If not specified, all expressions are shown.
         */
        fun expressionNames(expressionNames: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Whether to display the deployed configuration (true) or include any pending changes (false). Defaults to false.
         */
        var deployed: Boolean?
        /**
         * The name of the domain you want to describe.
         */
        var domainName: String?
        /**
         * Limits the DescribeExpressions response to the specified expressions. If not specified, all expressions are shown.
         */
        var expressionNames: List<String>?

        fun build(): DescribeExpressionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deployed: Boolean? = null
        override var domainName: String? = null
        override var expressionNames: List<String>? = null

        constructor(x: DescribeExpressionsRequest) : this() {
            this.deployed = x.deployed
            this.domainName = x.domainName
            this.expressionNames = x.expressionNames
        }

        override fun build(): DescribeExpressionsRequest = DescribeExpressionsRequest(this)
        override fun deployed(deployed: Boolean): FluentBuilder = apply { this.deployed = deployed }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun expressionNames(expressionNames: List<String>): FluentBuilder = apply { this.expressionNames = expressionNames }
    }
}
