// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * Container for the parameters to the DescribeAnalysisSchemes operation. Specifies the name of the domain you want to describe. To limit the response to particular analysis schemes, specify the names of the analysis schemes you want to describe. To show the active configuration and exclude any pending changes, set the Deployed option to true.
 */
class DescribeAnalysisSchemesRequest private constructor(builder: BuilderImpl) {
    /**
     * The analysis schemes you want to describe.
     */
    val analysisSchemeNames: List<String>? = builder.analysisSchemeNames
    /**
     * Whether to display the deployed configuration (true) or include any pending changes (false). Defaults to false.
     */
    val deployed: Boolean? = builder.deployed
    /**
     * The name of the domain you want to describe.
     */
    val domainName: String? = builder.domainName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeAnalysisSchemesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeAnalysisSchemesRequest(")
        append("analysisSchemeNames=$analysisSchemeNames,")
        append("deployed=$deployed,")
        append("domainName=$domainName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisSchemeNames?.hashCode() ?: 0
        result = 31 * result + (deployed?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeAnalysisSchemesRequest

        if (analysisSchemeNames != other.analysisSchemeNames) return false
        if (deployed != other.deployed) return false
        if (domainName != other.domainName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeAnalysisSchemesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeAnalysisSchemesRequest
        /**
         * The analysis schemes you want to describe.
         */
        fun analysisSchemeNames(analysisSchemeNames: List<String>): FluentBuilder
        /**
         * Whether to display the deployed configuration (true) or include any pending changes (false). Defaults to false.
         */
        fun deployed(deployed: Boolean): FluentBuilder
        /**
         * The name of the domain you want to describe.
         */
        fun domainName(domainName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The analysis schemes you want to describe.
         */
        var analysisSchemeNames: List<String>?
        /**
         * Whether to display the deployed configuration (true) or include any pending changes (false). Defaults to false.
         */
        var deployed: Boolean?
        /**
         * The name of the domain you want to describe.
         */
        var domainName: String?

        fun build(): DescribeAnalysisSchemesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analysisSchemeNames: List<String>? = null
        override var deployed: Boolean? = null
        override var domainName: String? = null

        constructor(x: DescribeAnalysisSchemesRequest) : this() {
            this.analysisSchemeNames = x.analysisSchemeNames
            this.deployed = x.deployed
            this.domainName = x.domainName
        }

        override fun build(): DescribeAnalysisSchemesRequest = DescribeAnalysisSchemesRequest(this)
        override fun analysisSchemeNames(analysisSchemeNames: List<String>): FluentBuilder = apply { this.analysisSchemeNames = analysisSchemeNames }
        override fun deployed(deployed: Boolean): FluentBuilder = apply { this.deployed = deployed }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
    }
}
