// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * Container for the parameters to the DeleteIndexField operation. Specifies the name of the domain you want to update and the name of the index field you want to delete.
 */
class DeleteIndexFieldRequest private constructor(builder: BuilderImpl) {
    /**
     * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
     */
    val domainName: String? = builder.domainName
    /**
     * The name of the index field your want to remove from the domain's indexing options.
     */
    val indexFieldName: String? = builder.indexFieldName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeleteIndexFieldRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteIndexFieldRequest(")
        append("domainName=$domainName,")
        append("indexFieldName=$indexFieldName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (indexFieldName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeleteIndexFieldRequest

        if (domainName != other.domainName) return false
        if (indexFieldName != other.indexFieldName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeleteIndexFieldRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeleteIndexFieldRequest
        /**
         * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * The name of the index field your want to remove from the domain's indexing options.
         */
        fun indexFieldName(indexFieldName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        var domainName: String?
        /**
         * The name of the index field your want to remove from the domain's indexing options.
         */
        var indexFieldName: String?

        fun build(): DeleteIndexFieldRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var domainName: String? = null
        override var indexFieldName: String? = null

        constructor(x: DeleteIndexFieldRequest) : this() {
            this.domainName = x.domainName
            this.indexFieldName = x.indexFieldName
        }

        override fun build(): DeleteIndexFieldRequest = DeleteIndexFieldRequest(this)
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun indexFieldName(indexFieldName: String): FluentBuilder = apply { this.indexFieldName = indexFieldName }
    }
}
