// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * Container for the parameters to the DeleteExpression operation. Specifies the name of the domain you want to update and the name of the expression you want to delete.
 */
class DeleteExpressionRequest private constructor(builder: BuilderImpl) {
    /**
     * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
     */
    val domainName: String? = builder.domainName
    /**
     * The name of the Expression to delete.
     */
    val expressionName: String? = builder.expressionName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeleteExpressionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteExpressionRequest(")
        append("domainName=$domainName,")
        append("expressionName=$expressionName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (expressionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeleteExpressionRequest

        if (domainName != other.domainName) return false
        if (expressionName != other.expressionName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeleteExpressionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeleteExpressionRequest
        /**
         * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * The name of the Expression to delete.
         */
        fun expressionName(expressionName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        var domainName: String?
        /**
         * The name of the Expression to delete.
         */
        var expressionName: String?

        fun build(): DeleteExpressionRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var domainName: String? = null
        override var expressionName: String? = null

        constructor(x: DeleteExpressionRequest) : this() {
            this.domainName = x.domainName
            this.expressionName = x.expressionName
        }

        override fun build(): DeleteExpressionRequest = DeleteExpressionRequest(this)
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun expressionName(expressionName: String): FluentBuilder = apply { this.expressionName = expressionName }
    }
}
