// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * Container for the parameters to the DefineSuggester operation. Specifies the name of the domain you want to update and the suggester configuration.
 */
class DefineSuggesterRequest private constructor(builder: BuilderImpl) {
    /**
     * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
     */
    val domainName: String? = builder.domainName
    /**
     * Configuration information for a search suggester. Each suggester has a unique name and specifies the text field you want to use for suggestions. The following options can be configured for a suggester: FuzzyMatching, SortExpression.
     */
    val suggester: Suggester? = builder.suggester

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DefineSuggesterRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DefineSuggesterRequest(")
        append("domainName=$domainName,")
        append("suggester=$suggester)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (suggester?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DefineSuggesterRequest

        if (domainName != other.domainName) return false
        if (suggester != other.suggester) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DefineSuggesterRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DefineSuggesterRequest
        /**
         * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * Configuration information for a search suggester. Each suggester has a unique name and specifies the text field you want to use for suggestions. The following options can be configured for a suggester: FuzzyMatching, SortExpression.
         */
        fun suggester(suggester: Suggester): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        var domainName: String?
        /**
         * Configuration information for a search suggester. Each suggester has a unique name and specifies the text field you want to use for suggestions. The following options can be configured for a suggester: FuzzyMatching, SortExpression.
         */
        var suggester: Suggester?

        fun build(): DefineSuggesterRequest
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.Suggester] inside the given [block]
         */
        fun suggester(block: Suggester.DslBuilder.() -> kotlin.Unit) {
            this.suggester = Suggester.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var domainName: String? = null
        override var suggester: Suggester? = null

        constructor(x: DefineSuggesterRequest) : this() {
            this.domainName = x.domainName
            this.suggester = x.suggester
        }

        override fun build(): DefineSuggesterRequest = DefineSuggesterRequest(this)
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun suggester(suggester: Suggester): FluentBuilder = apply { this.suggester = suggester }
    }
}
