// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * Container for the parameters to the DefineExpression operation. Specifies the name of the domain you want to update and the expression you want to configure.
 */
class DefineExpressionRequest private constructor(builder: BuilderImpl) {
    /**
     * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
     */
    val domainName: String? = builder.domainName
    /**
     * A named expression that can be evaluated at search time. Can be used to sort the search results, define other expressions, or return computed information in the search results.
     */
    val expression: Expression? = builder.expression

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DefineExpressionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DefineExpressionRequest(")
        append("domainName=$domainName,")
        append("expression=$expression)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (expression?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DefineExpressionRequest

        if (domainName != other.domainName) return false
        if (expression != other.expression) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DefineExpressionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DefineExpressionRequest
        /**
         * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * A named expression that can be evaluated at search time. Can be used to sort the search results, define other expressions, or return computed information in the search results.
         */
        fun expression(expression: Expression): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        var domainName: String?
        /**
         * A named expression that can be evaluated at search time. Can be used to sort the search results, define other expressions, or return computed information in the search results.
         */
        var expression: Expression?

        fun build(): DefineExpressionRequest
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.Expression] inside the given [block]
         */
        fun expression(block: Expression.DslBuilder.() -> kotlin.Unit) {
            this.expression = Expression.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var domainName: String? = null
        override var expression: Expression? = null

        constructor(x: DefineExpressionRequest) : this() {
            this.domainName = x.domainName
            this.expression = x.expression
        }

        override fun build(): DefineExpressionRequest = DefineExpressionRequest(this)
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun expression(expression: Expression): FluentBuilder = apply { this.expression = expression }
    }
}
