// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * Container for the parameters to the DefineAnalysisScheme operation. Specifies the name of the domain you want to update and the analysis scheme configuration.
 */
class DefineAnalysisSchemeRequest private constructor(builder: BuilderImpl) {
    /**
     * Configuration information for an analysis scheme. Each analysis scheme has a unique name and specifies the language of the text to be processed. The following options can be configured for an analysis scheme: Synonyms, Stopwords, StemmingDictionary, JapaneseTokenizationDictionary and AlgorithmicStemming.
     */
    val analysisScheme: AnalysisScheme? = builder.analysisScheme
    /**
     * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
     */
    val domainName: String? = builder.domainName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DefineAnalysisSchemeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DefineAnalysisSchemeRequest(")
        append("analysisScheme=$analysisScheme,")
        append("domainName=$domainName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisScheme?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DefineAnalysisSchemeRequest

        if (analysisScheme != other.analysisScheme) return false
        if (domainName != other.domainName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DefineAnalysisSchemeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DefineAnalysisSchemeRequest
        /**
         * Configuration information for an analysis scheme. Each analysis scheme has a unique name and specifies the language of the text to be processed. The following options can be configured for an analysis scheme: Synonyms, Stopwords, StemmingDictionary, JapaneseTokenizationDictionary and AlgorithmicStemming.
         */
        fun analysisScheme(analysisScheme: AnalysisScheme): FluentBuilder
        /**
         * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        fun domainName(domainName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Configuration information for an analysis scheme. Each analysis scheme has a unique name and specifies the language of the text to be processed. The following options can be configured for an analysis scheme: Synonyms, Stopwords, StemmingDictionary, JapaneseTokenizationDictionary and AlgorithmicStemming.
         */
        var analysisScheme: AnalysisScheme?
        /**
         * A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        var domainName: String?

        fun build(): DefineAnalysisSchemeRequest
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.AnalysisScheme] inside the given [block]
         */
        fun analysisScheme(block: AnalysisScheme.DslBuilder.() -> kotlin.Unit) {
            this.analysisScheme = AnalysisScheme.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analysisScheme: AnalysisScheme? = null
        override var domainName: String? = null

        constructor(x: DefineAnalysisSchemeRequest) : this() {
            this.analysisScheme = x.analysisScheme
            this.domainName = x.domainName
        }

        override fun build(): DefineAnalysisSchemeRequest = DefineAnalysisSchemeRequest(this)
        override fun analysisScheme(analysisScheme: AnalysisScheme): FluentBuilder = apply { this.analysisScheme = analysisScheme }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
    }
}
