// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * Configuration information for an analysis scheme. Each analysis scheme has a unique name and specifies the language of the text to be processed. The following options can be configured for an analysis scheme: Synonyms, Stopwords, StemmingDictionary, JapaneseTokenizationDictionary and AlgorithmicStemming.
 */
class AnalysisScheme private constructor(builder: BuilderImpl) {
    /**
     * Synonyms, stopwords, and stemming options for an analysis scheme. Includes tokenization dictionary for Japanese.
     */
    val analysisOptions: AnalysisOptions? = builder.analysisOptions
    /**
     * An <a href="http://tools.ietf.org/html/rfc4646" target="_blank">IETF RFC 4646 language code or mul  for multiple languages.
     */
    val analysisSchemeLanguage: AnalysisSchemeLanguage? = builder.analysisSchemeLanguage
    /**
     * Names must begin with a letter and can contain the following characters:
     * a-z (lowercase), 0-9, and _ (underscore).
     */
    val analysisSchemeName: String? = builder.analysisSchemeName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AnalysisScheme = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AnalysisScheme(")
        append("analysisOptions=$analysisOptions,")
        append("analysisSchemeLanguage=$analysisSchemeLanguage,")
        append("analysisSchemeName=$analysisSchemeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisOptions?.hashCode() ?: 0
        result = 31 * result + (analysisSchemeLanguage?.hashCode() ?: 0)
        result = 31 * result + (analysisSchemeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AnalysisScheme

        if (analysisOptions != other.analysisOptions) return false
        if (analysisSchemeLanguage != other.analysisSchemeLanguage) return false
        if (analysisSchemeName != other.analysisSchemeName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AnalysisScheme = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AnalysisScheme
        /**
         * Synonyms, stopwords, and stemming options for an analysis scheme. Includes tokenization dictionary for Japanese.
         */
        fun analysisOptions(analysisOptions: AnalysisOptions): FluentBuilder
        /**
         * An <a href="http://tools.ietf.org/html/rfc4646" target="_blank">IETF RFC 4646 language code or mul  for multiple languages.
         */
        fun analysisSchemeLanguage(analysisSchemeLanguage: AnalysisSchemeLanguage): FluentBuilder
        /**
         * Names must begin with a letter and can contain the following characters:
         * a-z (lowercase), 0-9, and _ (underscore).
         */
        fun analysisSchemeName(analysisSchemeName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Synonyms, stopwords, and stemming options for an analysis scheme. Includes tokenization dictionary for Japanese.
         */
        var analysisOptions: AnalysisOptions?
        /**
         * An <a href="http://tools.ietf.org/html/rfc4646" target="_blank">IETF RFC 4646 language code or mul  for multiple languages.
         */
        var analysisSchemeLanguage: AnalysisSchemeLanguage?
        /**
         * Names must begin with a letter and can contain the following characters:
         * a-z (lowercase), 0-9, and _ (underscore).
         */
        var analysisSchemeName: String?

        fun build(): AnalysisScheme
        /**
         * construct an [aws.sdk.kotlin.services.cloudsearch.model.AnalysisOptions] inside the given [block]
         */
        fun analysisOptions(block: AnalysisOptions.DslBuilder.() -> kotlin.Unit) {
            this.analysisOptions = AnalysisOptions.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analysisOptions: AnalysisOptions? = null
        override var analysisSchemeLanguage: AnalysisSchemeLanguage? = null
        override var analysisSchemeName: String? = null

        constructor(x: AnalysisScheme) : this() {
            this.analysisOptions = x.analysisOptions
            this.analysisSchemeLanguage = x.analysisSchemeLanguage
            this.analysisSchemeName = x.analysisSchemeName
        }

        override fun build(): AnalysisScheme = AnalysisScheme(this)
        override fun analysisOptions(analysisOptions: AnalysisOptions): FluentBuilder = apply { this.analysisOptions = analysisOptions }
        override fun analysisSchemeLanguage(analysisSchemeLanguage: AnalysisSchemeLanguage): FluentBuilder = apply { this.analysisSchemeLanguage = analysisSchemeLanguage }
        override fun analysisSchemeName(analysisSchemeName: String): FluentBuilder = apply { this.analysisSchemeName = analysisSchemeName }
    }
}
