// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch.model



/**
 * Synonyms, stopwords, and stemming options for an analysis scheme. Includes tokenization dictionary for Japanese.
 */
class AnalysisOptions private constructor(builder: BuilderImpl) {
    /**
     * The level of algorithmic stemming to perform: none, minimal, light, or full. The available levels vary depending on the language. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings" target="_blank">Language Specific Text Processing Settings in the Amazon CloudSearch Developer Guide
     */
    val algorithmicStemming: AlgorithmicStemming? = builder.algorithmicStemming
    /**
     * A JSON array that contains a collection of terms, tokens, readings and part of speech for Japanese Tokenizaiton. The Japanese tokenization dictionary enables you to override the default tokenization for selected terms. This is only valid for Japanese language fields.
     */
    val japaneseTokenizationDictionary: String? = builder.japaneseTokenizationDictionary
    /**
     * A JSON object that contains a collection of string:value pairs that each map a term to its stem. For example, {"term1": "stem1", "term2": "stem2", "term3": "stem3"}. The stemming dictionary is applied in addition to any algorithmic stemming. This enables you to override the results of the algorithmic stemming to correct specific cases of overstemming or understemming. The maximum size of a stemming dictionary is 500 KB.
     */
    val stemmingDictionary: String? = builder.stemmingDictionary
    /**
     * A  JSON array of terms to ignore during indexing and searching. For example, &#91;"a", "an", "the", "of"&#93;. The stopwords dictionary must explicitly list each word you want to ignore. Wildcards and regular expressions are not supported.
     */
    val stopwords: String? = builder.stopwords
    /**
     * A JSON object that defines synonym groups and aliases. A synonym group is an array of arrays, where each sub-array is a group of terms where each term in the group is considered a synonym of every other term in the group. The aliases value is an object that contains a collection of string:value pairs where the string specifies a term and the array of values specifies each of the aliases for that term. An alias is considered a synonym of the specified term, but the term is not considered a synonym of the alias. For more information about specifying synonyms, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html#synonyms">Synonyms in the Amazon CloudSearch Developer Guide.
     */
    val synonyms: String? = builder.synonyms

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AnalysisOptions = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AnalysisOptions(")
        append("algorithmicStemming=$algorithmicStemming,")
        append("japaneseTokenizationDictionary=$japaneseTokenizationDictionary,")
        append("stemmingDictionary=$stemmingDictionary,")
        append("stopwords=$stopwords,")
        append("synonyms=$synonyms)")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmicStemming?.hashCode() ?: 0
        result = 31 * result + (japaneseTokenizationDictionary?.hashCode() ?: 0)
        result = 31 * result + (stemmingDictionary?.hashCode() ?: 0)
        result = 31 * result + (stopwords?.hashCode() ?: 0)
        result = 31 * result + (synonyms?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AnalysisOptions

        if (algorithmicStemming != other.algorithmicStemming) return false
        if (japaneseTokenizationDictionary != other.japaneseTokenizationDictionary) return false
        if (stemmingDictionary != other.stemmingDictionary) return false
        if (stopwords != other.stopwords) return false
        if (synonyms != other.synonyms) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AnalysisOptions = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AnalysisOptions
        /**
         * The level of algorithmic stemming to perform: none, minimal, light, or full. The available levels vary depending on the language. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings" target="_blank">Language Specific Text Processing Settings in the Amazon CloudSearch Developer Guide
         */
        fun algorithmicStemming(algorithmicStemming: AlgorithmicStemming): FluentBuilder
        /**
         * A JSON array that contains a collection of terms, tokens, readings and part of speech for Japanese Tokenizaiton. The Japanese tokenization dictionary enables you to override the default tokenization for selected terms. This is only valid for Japanese language fields.
         */
        fun japaneseTokenizationDictionary(japaneseTokenizationDictionary: String): FluentBuilder
        /**
         * A JSON object that contains a collection of string:value pairs that each map a term to its stem. For example, {"term1": "stem1", "term2": "stem2", "term3": "stem3"}. The stemming dictionary is applied in addition to any algorithmic stemming. This enables you to override the results of the algorithmic stemming to correct specific cases of overstemming or understemming. The maximum size of a stemming dictionary is 500 KB.
         */
        fun stemmingDictionary(stemmingDictionary: String): FluentBuilder
        /**
         * A  JSON array of terms to ignore during indexing and searching. For example, &#91;"a", "an", "the", "of"&#93;. The stopwords dictionary must explicitly list each word you want to ignore. Wildcards and regular expressions are not supported.
         */
        fun stopwords(stopwords: String): FluentBuilder
        /**
         * A JSON object that defines synonym groups and aliases. A synonym group is an array of arrays, where each sub-array is a group of terms where each term in the group is considered a synonym of every other term in the group. The aliases value is an object that contains a collection of string:value pairs where the string specifies a term and the array of values specifies each of the aliases for that term. An alias is considered a synonym of the specified term, but the term is not considered a synonym of the alias. For more information about specifying synonyms, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html#synonyms">Synonyms in the Amazon CloudSearch Developer Guide.
         */
        fun synonyms(synonyms: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The level of algorithmic stemming to perform: none, minimal, light, or full. The available levels vary depending on the language. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings" target="_blank">Language Specific Text Processing Settings in the Amazon CloudSearch Developer Guide
         */
        var algorithmicStemming: AlgorithmicStemming?
        /**
         * A JSON array that contains a collection of terms, tokens, readings and part of speech for Japanese Tokenizaiton. The Japanese tokenization dictionary enables you to override the default tokenization for selected terms. This is only valid for Japanese language fields.
         */
        var japaneseTokenizationDictionary: String?
        /**
         * A JSON object that contains a collection of string:value pairs that each map a term to its stem. For example, {"term1": "stem1", "term2": "stem2", "term3": "stem3"}. The stemming dictionary is applied in addition to any algorithmic stemming. This enables you to override the results of the algorithmic stemming to correct specific cases of overstemming or understemming. The maximum size of a stemming dictionary is 500 KB.
         */
        var stemmingDictionary: String?
        /**
         * A  JSON array of terms to ignore during indexing and searching. For example, &#91;"a", "an", "the", "of"&#93;. The stopwords dictionary must explicitly list each word you want to ignore. Wildcards and regular expressions are not supported.
         */
        var stopwords: String?
        /**
         * A JSON object that defines synonym groups and aliases. A synonym group is an array of arrays, where each sub-array is a group of terms where each term in the group is considered a synonym of every other term in the group. The aliases value is an object that contains a collection of string:value pairs where the string specifies a term and the array of values specifies each of the aliases for that term. An alias is considered a synonym of the specified term, but the term is not considered a synonym of the alias. For more information about specifying synonyms, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html#synonyms">Synonyms in the Amazon CloudSearch Developer Guide.
         */
        var synonyms: String?

        fun build(): AnalysisOptions
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var algorithmicStemming: AlgorithmicStemming? = null
        override var japaneseTokenizationDictionary: String? = null
        override var stemmingDictionary: String? = null
        override var stopwords: String? = null
        override var synonyms: String? = null

        constructor(x: AnalysisOptions) : this() {
            this.algorithmicStemming = x.algorithmicStemming
            this.japaneseTokenizationDictionary = x.japaneseTokenizationDictionary
            this.stemmingDictionary = x.stemmingDictionary
            this.stopwords = x.stopwords
            this.synonyms = x.synonyms
        }

        override fun build(): AnalysisOptions = AnalysisOptions(this)
        override fun algorithmicStemming(algorithmicStemming: AlgorithmicStemming): FluentBuilder = apply { this.algorithmicStemming = algorithmicStemming }
        override fun japaneseTokenizationDictionary(japaneseTokenizationDictionary: String): FluentBuilder = apply { this.japaneseTokenizationDictionary = japaneseTokenizationDictionary }
        override fun stemmingDictionary(stemmingDictionary: String): FluentBuilder = apply { this.stemmingDictionary = stemmingDictionary }
        override fun stopwords(stopwords: String): FluentBuilder = apply { this.stopwords = stopwords }
        override fun synonyms(synonyms: String): FluentBuilder = apply { this.synonyms = synonyms }
    }
}
