// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.cloudsearch.model.*
import aws.smithy.kotlin.runtime.http.middleware.MutateHeaders
import aws.smithy.kotlin.runtime.http.middleware.RetryFeature
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation

private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

internal fun registerBuildSuggestersMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<BuildSuggestersRequest,BuildSuggestersResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerCreateDomainMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<CreateDomainRequest,CreateDomainResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDefineAnalysisSchemeMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DefineAnalysisSchemeRequest,DefineAnalysisSchemeResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDefineExpressionMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DefineExpressionRequest,DefineExpressionResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDefineIndexFieldMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DefineIndexFieldRequest,DefineIndexFieldResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDefineSuggesterMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DefineSuggesterRequest,DefineSuggesterResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDeleteAnalysisSchemeMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DeleteAnalysisSchemeRequest,DeleteAnalysisSchemeResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDeleteDomainMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DeleteDomainRequest,DeleteDomainResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDeleteExpressionMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DeleteExpressionRequest,DeleteExpressionResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDeleteIndexFieldMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DeleteIndexFieldRequest,DeleteIndexFieldResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDeleteSuggesterMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DeleteSuggesterRequest,DeleteSuggesterResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDescribeAnalysisSchemesMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DescribeAnalysisSchemesRequest,DescribeAnalysisSchemesResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDescribeAvailabilityOptionsMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DescribeAvailabilityOptionsRequest,DescribeAvailabilityOptionsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDescribeDomainEndpointOptionsMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DescribeDomainEndpointOptionsRequest,DescribeDomainEndpointOptionsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDescribeDomainsMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DescribeDomainsRequest,DescribeDomainsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDescribeExpressionsMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DescribeExpressionsRequest,DescribeExpressionsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDescribeIndexFieldsMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DescribeIndexFieldsRequest,DescribeIndexFieldsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDescribeScalingParametersMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DescribeScalingParametersRequest,DescribeScalingParametersResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDescribeServiceAccessPoliciesMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DescribeServiceAccessPoliciesRequest,DescribeServiceAccessPoliciesResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerDescribeSuggestersMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<DescribeSuggestersRequest,DescribeSuggestersResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerIndexDocumentsMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<IndexDocumentsRequest,IndexDocumentsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerListDomainNamesMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<ListDomainNamesRequest,ListDomainNamesResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerUpdateAvailabilityOptionsMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<UpdateAvailabilityOptionsRequest,UpdateAvailabilityOptionsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerUpdateDomainEndpointOptionsMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<UpdateDomainEndpointOptionsRequest,UpdateDomainEndpointOptionsResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerUpdateScalingParametersMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<UpdateScalingParametersRequest,UpdateScalingParametersResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}

internal fun registerUpdateServiceAccessPoliciesMiddleware(config: CloudSearchClient.Config, op: SdkHttpOperation<UpdateServiceAccessPoliciesRequest,UpdateServiceAccessPoliciesResponse>) {
    op.apply {
        install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(MutateHeaders) {
            setIfMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "cloudsearch"
        }
    }
}
