// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.cloudsearch.model.*
import aws.sdk.kotlin.services.cloudsearch.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "CloudSearch"
const val ServiceApiVersion: String = "2013-01-01"
const val SdkVersion: String = "0.9.1-alpha"

internal class DefaultCloudSearchClient(override val config: CloudSearchClient.Config) : CloudSearchClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Indexes the search suggestions. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html#configuring-suggesters">Configuring Suggesters in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun buildSuggesters(input: BuildSuggestersRequest): BuildSuggestersResponse {
        val op = SdkHttpOperation.build<BuildSuggestersRequest, BuildSuggestersResponse> {
            serializer = BuildSuggestersOperationSerializer()
            deserializer = BuildSuggestersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BuildSuggesters"
            }
        }
        registerBuildSuggestersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new search domain. For more information,
     * see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/creating-domains.html" target="_blank">Creating a Search Domain in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse {
        val op = SdkHttpOperation.build<CreateDomainRequest, CreateDomainResponse> {
            serializer = CreateDomainOperationSerializer()
            deserializer = CreateDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDomain"
            }
        }
        registerCreateDomainMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Configures an analysis scheme that can be applied to a text or text-array field to define language-specific text processing options. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html" target="_blank">Configuring Analysis Schemes in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun defineAnalysisScheme(input: DefineAnalysisSchemeRequest): DefineAnalysisSchemeResponse {
        val op = SdkHttpOperation.build<DefineAnalysisSchemeRequest, DefineAnalysisSchemeResponse> {
            serializer = DefineAnalysisSchemeOperationSerializer()
            deserializer = DefineAnalysisSchemeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DefineAnalysisScheme"
            }
        }
        registerDefineAnalysisSchemeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Configures an Expression for the search domain. Used to create new expressions and modify existing ones.  If the expression exists, the new configuration replaces the old one. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun defineExpression(input: DefineExpressionRequest): DefineExpressionResponse {
        val op = SdkHttpOperation.build<DefineExpressionRequest, DefineExpressionResponse> {
            serializer = DefineExpressionOperationSerializer()
            deserializer = DefineExpressionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DefineExpression"
            }
        }
        registerDefineExpressionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Configures an IndexField for the search domain. Used to create new fields and modify existing ones. You must specify the name of the domain you are configuring and an index field configuration. The index field configuration specifies a unique name, the index field type, and the options you want to configure for the field. The options you can specify depend on the IndexFieldType. If the field exists, the new configuration replaces the old one. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html" target="_blank">Configuring Index Fields in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun defineIndexField(input: DefineIndexFieldRequest): DefineIndexFieldResponse {
        val op = SdkHttpOperation.build<DefineIndexFieldRequest, DefineIndexFieldResponse> {
            serializer = DefineIndexFieldOperationSerializer()
            deserializer = DefineIndexFieldOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DefineIndexField"
            }
        }
        registerDefineIndexFieldMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Configures a suggester for a domain. A suggester enables you to display possible matches before users finish typing their queries. When you configure a suggester, you must specify the name of the text field you want to search for possible matches and a unique name for the suggester. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html" target="_blank">Getting Search Suggestions in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun defineSuggester(input: DefineSuggesterRequest): DefineSuggesterResponse {
        val op = SdkHttpOperation.build<DefineSuggesterRequest, DefineSuggesterResponse> {
            serializer = DefineSuggesterOperationSerializer()
            deserializer = DefineSuggesterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DefineSuggester"
            }
        }
        registerDefineSuggesterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an analysis scheme. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html" target="_blank">Configuring Analysis Schemes in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun deleteAnalysisScheme(input: DeleteAnalysisSchemeRequest): DeleteAnalysisSchemeResponse {
        val op = SdkHttpOperation.build<DeleteAnalysisSchemeRequest, DeleteAnalysisSchemeResponse> {
            serializer = DeleteAnalysisSchemeOperationSerializer()
            deserializer = DeleteAnalysisSchemeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAnalysisScheme"
            }
        }
        registerDeleteAnalysisSchemeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Permanently deletes a search domain and all of its data. Once a domain has been deleted, it cannot be recovered. For more information,
     * see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/deleting-domains.html" target="_blank">Deleting a Search  Domain in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse {
        val op = SdkHttpOperation.build<DeleteDomainRequest, DeleteDomainResponse> {
            serializer = DeleteDomainOperationSerializer()
            deserializer = DeleteDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDomain"
            }
        }
        registerDeleteDomainMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes an Expression from the search domain. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun deleteExpression(input: DeleteExpressionRequest): DeleteExpressionResponse {
        val op = SdkHttpOperation.build<DeleteExpressionRequest, DeleteExpressionResponse> {
            serializer = DeleteExpressionOperationSerializer()
            deserializer = DeleteExpressionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteExpression"
            }
        }
        registerDeleteExpressionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes an IndexField from the search domain. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html" target="_blank">Configuring Index Fields in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun deleteIndexField(input: DeleteIndexFieldRequest): DeleteIndexFieldResponse {
        val op = SdkHttpOperation.build<DeleteIndexFieldRequest, DeleteIndexFieldResponse> {
            serializer = DeleteIndexFieldOperationSerializer()
            deserializer = DeleteIndexFieldOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteIndexField"
            }
        }
        registerDeleteIndexFieldMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a suggester. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html" target="_blank">Getting Search Suggestions in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun deleteSuggester(input: DeleteSuggesterRequest): DeleteSuggesterResponse {
        val op = SdkHttpOperation.build<DeleteSuggesterRequest, DeleteSuggesterResponse> {
            serializer = DeleteSuggesterOperationSerializer()
            deserializer = DeleteSuggesterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSuggester"
            }
        }
        registerDeleteSuggesterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the analysis schemes configured for a domain. An analysis scheme defines language-specific text processing options for a text field. Can be limited to specific analysis schemes by name.  By default, shows all analysis schemes and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes.  For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html" target="_blank">Configuring Analysis Schemes in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun describeAnalysisSchemes(input: DescribeAnalysisSchemesRequest): DescribeAnalysisSchemesResponse {
        val op = SdkHttpOperation.build<DescribeAnalysisSchemesRequest, DescribeAnalysisSchemesResponse> {
            serializer = DescribeAnalysisSchemesOperationSerializer()
            deserializer = DescribeAnalysisSchemesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAnalysisSchemes"
            }
        }
        registerDescribeAnalysisSchemesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the availability options configured for a domain. By default, shows the configuration with any pending changes. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information, see  <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html" target="_blank">Configuring Availability Options in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun describeAvailabilityOptions(input: DescribeAvailabilityOptionsRequest): DescribeAvailabilityOptionsResponse {
        val op = SdkHttpOperation.build<DescribeAvailabilityOptionsRequest, DescribeAvailabilityOptionsResponse> {
            serializer = DescribeAvailabilityOptionsOperationSerializer()
            deserializer = DescribeAvailabilityOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAvailabilityOptions"
            }
        }
        registerDescribeAvailabilityOptionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS. For more information, see  <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html" target="_blank">Configuring Domain Endpoint Options in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun describeDomainEndpointOptions(input: DescribeDomainEndpointOptionsRequest): DescribeDomainEndpointOptionsResponse {
        val op = SdkHttpOperation.build<DescribeDomainEndpointOptionsRequest, DescribeDomainEndpointOptionsResponse> {
            serializer = DescribeDomainEndpointOptionsOperationSerializer()
            deserializer = DescribeDomainEndpointOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDomainEndpointOptions"
            }
        }
        registerDescribeDomainEndpointOptionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the search domains owned by this account. Can be limited to specific domains. Shows
     * all domains by default. To get the number of searchable documents in a domain, use the console or submit a matchall request to your domain's search endpoint: q=matchall&amp;q.parser=structured&amp;size=0. For more information,
     * see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html" target="_blank">Getting Information about a Search Domain in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun describeDomains(input: DescribeDomainsRequest): DescribeDomainsResponse {
        val op = SdkHttpOperation.build<DescribeDomainsRequest, DescribeDomainsResponse> {
            serializer = DescribeDomainsOperationSerializer()
            deserializer = DescribeDomainsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDomains"
            }
        }
        registerDescribeDomainsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the expressions configured for the search domain. Can be limited to specific expressions by name. By default, shows all expressions and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information, see  <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun describeExpressions(input: DescribeExpressionsRequest): DescribeExpressionsResponse {
        val op = SdkHttpOperation.build<DescribeExpressionsRequest, DescribeExpressionsResponse> {
            serializer = DescribeExpressionsOperationSerializer()
            deserializer = DescribeExpressionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeExpressions"
            }
        }
        registerDescribeExpressionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the index fields configured for the search domain.
     * Can be limited to specific fields by name.  By default, shows all fields and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information,
     * see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html" target="_blank">Getting Domain Information in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun describeIndexFields(input: DescribeIndexFieldsRequest): DescribeIndexFieldsResponse {
        val op = SdkHttpOperation.build<DescribeIndexFieldsRequest, DescribeIndexFieldsResponse> {
            serializer = DescribeIndexFieldsOperationSerializer()
            deserializer = DescribeIndexFieldsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIndexFields"
            }
        }
        registerDescribeIndexFieldsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the scaling parameters configured for a domain. A domain's scaling parameters specify the desired search instance type and replication count. For more information, see   <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html" target="_blank">Configuring Scaling Options in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun describeScalingParameters(input: DescribeScalingParametersRequest): DescribeScalingParametersResponse {
        val op = SdkHttpOperation.build<DescribeScalingParametersRequest, DescribeScalingParametersResponse> {
            serializer = DescribeScalingParametersOperationSerializer()
            deserializer = DescribeScalingParametersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeScalingParameters"
            }
        }
        registerDescribeScalingParametersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the access policies that control access to the domain's document and search endpoints. By default, shows the configuration with any pending changes. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information,
     * see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html" target="_blank">Configuring Access for a Search Domain in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun describeServiceAccessPolicies(input: DescribeServiceAccessPoliciesRequest): DescribeServiceAccessPoliciesResponse {
        val op = SdkHttpOperation.build<DescribeServiceAccessPoliciesRequest, DescribeServiceAccessPoliciesResponse> {
            serializer = DescribeServiceAccessPoliciesOperationSerializer()
            deserializer = DescribeServiceAccessPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeServiceAccessPolicies"
            }
        }
        registerDescribeServiceAccessPoliciesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the suggesters configured for a domain. A suggester enables you to display possible matches before users finish typing their queries.  Can be limited to specific suggesters by name.  By default, shows all suggesters and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes.  For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html" target="_blank">Getting Search Suggestions in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun describeSuggesters(input: DescribeSuggestersRequest): DescribeSuggestersResponse {
        val op = SdkHttpOperation.build<DescribeSuggestersRequest, DescribeSuggestersResponse> {
            serializer = DescribeSuggestersOperationSerializer()
            deserializer = DescribeSuggestersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSuggesters"
            }
        }
        registerDescribeSuggestersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Tells the search domain to start indexing its documents using the latest indexing options. This operation must be invoked to activate options whose OptionStatus is  RequiresIndexDocuments.
     */
    override suspend fun indexDocuments(input: IndexDocumentsRequest): IndexDocumentsResponse {
        val op = SdkHttpOperation.build<IndexDocumentsRequest, IndexDocumentsResponse> {
            serializer = IndexDocumentsOperationSerializer()
            deserializer = IndexDocumentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "IndexDocuments"
            }
        }
        registerIndexDocumentsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all search domains owned by an account.
     */
    override suspend fun listDomainNames(input: ListDomainNamesRequest): ListDomainNamesResponse {
        val op = SdkHttpOperation.build<ListDomainNamesRequest, ListDomainNamesResponse> {
            serializer = ListDomainNamesOperationSerializer()
            deserializer = ListDomainNamesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDomainNames"
            }
        }
        registerListDomainNamesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Configures the availability options for a domain. Enabling the Multi-AZ option expands an Amazon CloudSearch domain to an additional Availability Zone in the same Region to increase fault tolerance in the event of a service disruption. Changes to the Multi-AZ option can take about half an hour to become active. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html" target="_blank">Configuring Availability Options in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun updateAvailabilityOptions(input: UpdateAvailabilityOptionsRequest): UpdateAvailabilityOptionsResponse {
        val op = SdkHttpOperation.build<UpdateAvailabilityOptionsRequest, UpdateAvailabilityOptionsResponse> {
            serializer = UpdateAvailabilityOptionsOperationSerializer()
            deserializer = UpdateAvailabilityOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAvailabilityOptions"
            }
        }
        registerUpdateAvailabilityOptionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html" target="_blank">Configuring Domain Endpoint Options in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun updateDomainEndpointOptions(input: UpdateDomainEndpointOptionsRequest): UpdateDomainEndpointOptionsResponse {
        val op = SdkHttpOperation.build<UpdateDomainEndpointOptionsRequest, UpdateDomainEndpointOptionsResponse> {
            serializer = UpdateDomainEndpointOptionsOperationSerializer()
            deserializer = UpdateDomainEndpointOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDomainEndpointOptions"
            }
        }
        registerUpdateDomainEndpointOptionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Configures scaling parameters for a domain. A domain's scaling parameters specify the desired search instance type and replication count. Amazon CloudSearch will still automatically scale your domain based on the volume of data and traffic, but not below the desired instance type and replication count. If the Multi-AZ option is enabled, these values control the resources used per Availability Zone. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html" target="_blank">Configuring Scaling Options in the Amazon CloudSearch Developer Guide.
     */
    override suspend fun updateScalingParameters(input: UpdateScalingParametersRequest): UpdateScalingParametersResponse {
        val op = SdkHttpOperation.build<UpdateScalingParametersRequest, UpdateScalingParametersResponse> {
            serializer = UpdateScalingParametersOperationSerializer()
            deserializer = UpdateScalingParametersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateScalingParameters"
            }
        }
        registerUpdateScalingParametersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Configures the access rules that control access to the domain's document and search endpoints.
     * For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html" target="_blank">
     * Configuring Access for an Amazon CloudSearch Domain.
     */
    override suspend fun updateServiceAccessPolicies(input: UpdateServiceAccessPoliciesRequest): UpdateServiceAccessPoliciesResponse {
        val op = SdkHttpOperation.build<UpdateServiceAccessPoliciesRequest, UpdateServiceAccessPoliciesResponse> {
            serializer = UpdateServiceAccessPoliciesOperationSerializer()
            deserializer = UpdateServiceAccessPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateServiceAccessPolicies"
            }
        }
        registerUpdateServiceAccessPoliciesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
