// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudsearch

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.cloudsearch.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.cloudsearch.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>Amazon CloudSearch Configuration Service</fullname>
 * You use the Amazon CloudSearch configuration service to create, configure, and manage search domains.
 * Configuration service  requests are submitted using the AWS Query protocol. AWS Query requests
 * are HTTP or HTTPS requests submitted via HTTP GET or POST with a query parameter named Action.
 * The endpoint for configuration service requests is region-specific: cloudsearch.region.amazonaws.com.
 * For example, cloudsearch.us-east-1.amazonaws.com. For a current list of supported regions and endpoints,
 * see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html#cloudsearch_region" target="_blank">Regions and Endpoints.
 */
interface CloudSearchClient : SdkClient {

    override val serviceName: String
        get() = "CloudSearch"
    /**
     * CloudSearchClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): CloudSearchClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultCloudSearchClient(config)
        }

        operator fun invoke(config: Config): CloudSearchClient = DefaultCloudSearchClient(config)

        /**
         * Construct a [CloudSearchClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): CloudSearchClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return CloudSearchClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Indexes the search suggestions. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html#configuring-suggesters">Configuring Suggesters in the Amazon CloudSearch Developer Guide.
     */
    suspend fun buildSuggesters(input: BuildSuggestersRequest): BuildSuggestersResponse

    /**
     * Indexes the search suggestions. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html#configuring-suggesters">Configuring Suggesters in the Amazon CloudSearch Developer Guide.
     */
    suspend fun buildSuggesters(block: BuildSuggestersRequest.DslBuilder.() -> Unit) = buildSuggesters(BuildSuggestersRequest.builder().apply(block).build())

    /**
     * Creates a new search domain. For more information,
     * see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/creating-domains.html" target="_blank">Creating a Search Domain in the Amazon CloudSearch Developer Guide.
     */
    suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse

    /**
     * Creates a new search domain. For more information,
     * see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/creating-domains.html" target="_blank">Creating a Search Domain in the Amazon CloudSearch Developer Guide.
     */
    suspend fun createDomain(block: CreateDomainRequest.DslBuilder.() -> Unit) = createDomain(CreateDomainRequest.builder().apply(block).build())

    /**
     * Configures an analysis scheme that can be applied to a text or text-array field to define language-specific text processing options. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html" target="_blank">Configuring Analysis Schemes in the Amazon CloudSearch Developer Guide.
     */
    suspend fun defineAnalysisScheme(input: DefineAnalysisSchemeRequest): DefineAnalysisSchemeResponse

    /**
     * Configures an analysis scheme that can be applied to a text or text-array field to define language-specific text processing options. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html" target="_blank">Configuring Analysis Schemes in the Amazon CloudSearch Developer Guide.
     */
    suspend fun defineAnalysisScheme(block: DefineAnalysisSchemeRequest.DslBuilder.() -> Unit) = defineAnalysisScheme(DefineAnalysisSchemeRequest.builder().apply(block).build())

    /**
     * Configures an Expression for the search domain. Used to create new expressions and modify existing ones.  If the expression exists, the new configuration replaces the old one. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions in the Amazon CloudSearch Developer Guide.
     */
    suspend fun defineExpression(input: DefineExpressionRequest): DefineExpressionResponse

    /**
     * Configures an Expression for the search domain. Used to create new expressions and modify existing ones.  If the expression exists, the new configuration replaces the old one. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions in the Amazon CloudSearch Developer Guide.
     */
    suspend fun defineExpression(block: DefineExpressionRequest.DslBuilder.() -> Unit) = defineExpression(DefineExpressionRequest.builder().apply(block).build())

    /**
     * Configures an IndexField for the search domain. Used to create new fields and modify existing ones. You must specify the name of the domain you are configuring and an index field configuration. The index field configuration specifies a unique name, the index field type, and the options you want to configure for the field. The options you can specify depend on the IndexFieldType. If the field exists, the new configuration replaces the old one. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html" target="_blank">Configuring Index Fields in the Amazon CloudSearch Developer Guide.
     */
    suspend fun defineIndexField(input: DefineIndexFieldRequest): DefineIndexFieldResponse

    /**
     * Configures an IndexField for the search domain. Used to create new fields and modify existing ones. You must specify the name of the domain you are configuring and an index field configuration. The index field configuration specifies a unique name, the index field type, and the options you want to configure for the field. The options you can specify depend on the IndexFieldType. If the field exists, the new configuration replaces the old one. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html" target="_blank">Configuring Index Fields in the Amazon CloudSearch Developer Guide.
     */
    suspend fun defineIndexField(block: DefineIndexFieldRequest.DslBuilder.() -> Unit) = defineIndexField(DefineIndexFieldRequest.builder().apply(block).build())

    /**
     * Configures a suggester for a domain. A suggester enables you to display possible matches before users finish typing their queries. When you configure a suggester, you must specify the name of the text field you want to search for possible matches and a unique name for the suggester. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html" target="_blank">Getting Search Suggestions in the Amazon CloudSearch Developer Guide.
     */
    suspend fun defineSuggester(input: DefineSuggesterRequest): DefineSuggesterResponse

    /**
     * Configures a suggester for a domain. A suggester enables you to display possible matches before users finish typing their queries. When you configure a suggester, you must specify the name of the text field you want to search for possible matches and a unique name for the suggester. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html" target="_blank">Getting Search Suggestions in the Amazon CloudSearch Developer Guide.
     */
    suspend fun defineSuggester(block: DefineSuggesterRequest.DslBuilder.() -> Unit) = defineSuggester(DefineSuggesterRequest.builder().apply(block).build())

    /**
     * Deletes an analysis scheme. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html" target="_blank">Configuring Analysis Schemes in the Amazon CloudSearch Developer Guide.
     */
    suspend fun deleteAnalysisScheme(input: DeleteAnalysisSchemeRequest): DeleteAnalysisSchemeResponse

    /**
     * Deletes an analysis scheme. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html" target="_blank">Configuring Analysis Schemes in the Amazon CloudSearch Developer Guide.
     */
    suspend fun deleteAnalysisScheme(block: DeleteAnalysisSchemeRequest.DslBuilder.() -> Unit) = deleteAnalysisScheme(DeleteAnalysisSchemeRequest.builder().apply(block).build())

    /**
     * Permanently deletes a search domain and all of its data. Once a domain has been deleted, it cannot be recovered. For more information,
     * see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/deleting-domains.html" target="_blank">Deleting a Search  Domain in the Amazon CloudSearch Developer Guide.
     */
    suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse

    /**
     * Permanently deletes a search domain and all of its data. Once a domain has been deleted, it cannot be recovered. For more information,
     * see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/deleting-domains.html" target="_blank">Deleting a Search  Domain in the Amazon CloudSearch Developer Guide.
     */
    suspend fun deleteDomain(block: DeleteDomainRequest.DslBuilder.() -> Unit) = deleteDomain(DeleteDomainRequest.builder().apply(block).build())

    /**
     * Removes an Expression from the search domain. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions in the Amazon CloudSearch Developer Guide.
     */
    suspend fun deleteExpression(input: DeleteExpressionRequest): DeleteExpressionResponse

    /**
     * Removes an Expression from the search domain. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions in the Amazon CloudSearch Developer Guide.
     */
    suspend fun deleteExpression(block: DeleteExpressionRequest.DslBuilder.() -> Unit) = deleteExpression(DeleteExpressionRequest.builder().apply(block).build())

    /**
     * Removes an IndexField from the search domain. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html" target="_blank">Configuring Index Fields in the Amazon CloudSearch Developer Guide.
     */
    suspend fun deleteIndexField(input: DeleteIndexFieldRequest): DeleteIndexFieldResponse

    /**
     * Removes an IndexField from the search domain. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html" target="_blank">Configuring Index Fields in the Amazon CloudSearch Developer Guide.
     */
    suspend fun deleteIndexField(block: DeleteIndexFieldRequest.DslBuilder.() -> Unit) = deleteIndexField(DeleteIndexFieldRequest.builder().apply(block).build())

    /**
     * Deletes a suggester. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html" target="_blank">Getting Search Suggestions in the Amazon CloudSearch Developer Guide.
     */
    suspend fun deleteSuggester(input: DeleteSuggesterRequest): DeleteSuggesterResponse

    /**
     * Deletes a suggester. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html" target="_blank">Getting Search Suggestions in the Amazon CloudSearch Developer Guide.
     */
    suspend fun deleteSuggester(block: DeleteSuggesterRequest.DslBuilder.() -> Unit) = deleteSuggester(DeleteSuggesterRequest.builder().apply(block).build())

    /**
     * Gets the analysis schemes configured for a domain. An analysis scheme defines language-specific text processing options for a text field. Can be limited to specific analysis schemes by name.  By default, shows all analysis schemes and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes.  For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html" target="_blank">Configuring Analysis Schemes in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeAnalysisSchemes(input: DescribeAnalysisSchemesRequest): DescribeAnalysisSchemesResponse

    /**
     * Gets the analysis schemes configured for a domain. An analysis scheme defines language-specific text processing options for a text field. Can be limited to specific analysis schemes by name.  By default, shows all analysis schemes and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes.  For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html" target="_blank">Configuring Analysis Schemes in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeAnalysisSchemes(block: DescribeAnalysisSchemesRequest.DslBuilder.() -> Unit) = describeAnalysisSchemes(DescribeAnalysisSchemesRequest.builder().apply(block).build())

    /**
     * Gets the availability options configured for a domain. By default, shows the configuration with any pending changes. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information, see  <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html" target="_blank">Configuring Availability Options in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeAvailabilityOptions(input: DescribeAvailabilityOptionsRequest): DescribeAvailabilityOptionsResponse

    /**
     * Gets the availability options configured for a domain. By default, shows the configuration with any pending changes. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information, see  <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html" target="_blank">Configuring Availability Options in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeAvailabilityOptions(block: DescribeAvailabilityOptionsRequest.DslBuilder.() -> Unit) = describeAvailabilityOptions(DescribeAvailabilityOptionsRequest.builder().apply(block).build())

    /**
     * Returns the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS. For more information, see  <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html" target="_blank">Configuring Domain Endpoint Options in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeDomainEndpointOptions(input: DescribeDomainEndpointOptionsRequest): DescribeDomainEndpointOptionsResponse

    /**
     * Returns the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS. For more information, see  <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html" target="_blank">Configuring Domain Endpoint Options in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeDomainEndpointOptions(block: DescribeDomainEndpointOptionsRequest.DslBuilder.() -> Unit) = describeDomainEndpointOptions(DescribeDomainEndpointOptionsRequest.builder().apply(block).build())

    /**
     * Gets information about the search domains owned by this account. Can be limited to specific domains. Shows
     * all domains by default. To get the number of searchable documents in a domain, use the console or submit a matchall request to your domain's search endpoint: q=matchall&amp;q.parser=structured&amp;size=0. For more information,
     * see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html" target="_blank">Getting Information about a Search Domain in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeDomains(input: DescribeDomainsRequest): DescribeDomainsResponse

    /**
     * Gets information about the search domains owned by this account. Can be limited to specific domains. Shows
     * all domains by default. To get the number of searchable documents in a domain, use the console or submit a matchall request to your domain's search endpoint: q=matchall&amp;q.parser=structured&amp;size=0. For more information,
     * see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html" target="_blank">Getting Information about a Search Domain in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeDomains(block: DescribeDomainsRequest.DslBuilder.() -> Unit) = describeDomains(DescribeDomainsRequest.builder().apply(block).build())

    /**
     * Gets the expressions configured for the search domain. Can be limited to specific expressions by name. By default, shows all expressions and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information, see  <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeExpressions(input: DescribeExpressionsRequest): DescribeExpressionsResponse

    /**
     * Gets the expressions configured for the search domain. Can be limited to specific expressions by name. By default, shows all expressions and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information, see  <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeExpressions(block: DescribeExpressionsRequest.DslBuilder.() -> Unit) = describeExpressions(DescribeExpressionsRequest.builder().apply(block).build())

    /**
     * Gets information about the index fields configured for the search domain.
     * Can be limited to specific fields by name.  By default, shows all fields and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information,
     * see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html" target="_blank">Getting Domain Information in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeIndexFields(input: DescribeIndexFieldsRequest): DescribeIndexFieldsResponse

    /**
     * Gets information about the index fields configured for the search domain.
     * Can be limited to specific fields by name.  By default, shows all fields and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information,
     * see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html" target="_blank">Getting Domain Information in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeIndexFields(block: DescribeIndexFieldsRequest.DslBuilder.() -> Unit) = describeIndexFields(DescribeIndexFieldsRequest.builder().apply(block).build())

    /**
     * Gets the scaling parameters configured for a domain. A domain's scaling parameters specify the desired search instance type and replication count. For more information, see   <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html" target="_blank">Configuring Scaling Options in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeScalingParameters(input: DescribeScalingParametersRequest): DescribeScalingParametersResponse

    /**
     * Gets the scaling parameters configured for a domain. A domain's scaling parameters specify the desired search instance type and replication count. For more information, see   <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html" target="_blank">Configuring Scaling Options in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeScalingParameters(block: DescribeScalingParametersRequest.DslBuilder.() -> Unit) = describeScalingParameters(DescribeScalingParametersRequest.builder().apply(block).build())

    /**
     * Gets information about the access policies that control access to the domain's document and search endpoints. By default, shows the configuration with any pending changes. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information,
     * see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html" target="_blank">Configuring Access for a Search Domain in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeServiceAccessPolicies(input: DescribeServiceAccessPoliciesRequest): DescribeServiceAccessPoliciesResponse

    /**
     * Gets information about the access policies that control access to the domain's document and search endpoints. By default, shows the configuration with any pending changes. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information,
     * see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html" target="_blank">Configuring Access for a Search Domain in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeServiceAccessPolicies(block: DescribeServiceAccessPoliciesRequest.DslBuilder.() -> Unit) = describeServiceAccessPolicies(DescribeServiceAccessPoliciesRequest.builder().apply(block).build())

    /**
     * Gets the suggesters configured for a domain. A suggester enables you to display possible matches before users finish typing their queries.  Can be limited to specific suggesters by name.  By default, shows all suggesters and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes.  For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html" target="_blank">Getting Search Suggestions in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeSuggesters(input: DescribeSuggestersRequest): DescribeSuggestersResponse

    /**
     * Gets the suggesters configured for a domain. A suggester enables you to display possible matches before users finish typing their queries.  Can be limited to specific suggesters by name.  By default, shows all suggesters and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes.  For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html" target="_blank">Getting Search Suggestions in the Amazon CloudSearch Developer Guide.
     */
    suspend fun describeSuggesters(block: DescribeSuggestersRequest.DslBuilder.() -> Unit) = describeSuggesters(DescribeSuggestersRequest.builder().apply(block).build())

    /**
     * Tells the search domain to start indexing its documents using the latest indexing options. This operation must be invoked to activate options whose OptionStatus is  RequiresIndexDocuments.
     */
    suspend fun indexDocuments(input: IndexDocumentsRequest): IndexDocumentsResponse

    /**
     * Tells the search domain to start indexing its documents using the latest indexing options. This operation must be invoked to activate options whose OptionStatus is  RequiresIndexDocuments.
     */
    suspend fun indexDocuments(block: IndexDocumentsRequest.DslBuilder.() -> Unit) = indexDocuments(IndexDocumentsRequest.builder().apply(block).build())

    /**
     * Lists all search domains owned by an account.
     */
    suspend fun listDomainNames(input: ListDomainNamesRequest): ListDomainNamesResponse

    /**
     * Lists all search domains owned by an account.
     */
    suspend fun listDomainNames(block: ListDomainNamesRequest.DslBuilder.() -> Unit) = listDomainNames(ListDomainNamesRequest.builder().apply(block).build())

    /**
     * Configures the availability options for a domain. Enabling the Multi-AZ option expands an Amazon CloudSearch domain to an additional Availability Zone in the same Region to increase fault tolerance in the event of a service disruption. Changes to the Multi-AZ option can take about half an hour to become active. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html" target="_blank">Configuring Availability Options in the Amazon CloudSearch Developer Guide.
     */
    suspend fun updateAvailabilityOptions(input: UpdateAvailabilityOptionsRequest): UpdateAvailabilityOptionsResponse

    /**
     * Configures the availability options for a domain. Enabling the Multi-AZ option expands an Amazon CloudSearch domain to an additional Availability Zone in the same Region to increase fault tolerance in the event of a service disruption. Changes to the Multi-AZ option can take about half an hour to become active. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html" target="_blank">Configuring Availability Options in the Amazon CloudSearch Developer Guide.
     */
    suspend fun updateAvailabilityOptions(block: UpdateAvailabilityOptionsRequest.DslBuilder.() -> Unit) = updateAvailabilityOptions(UpdateAvailabilityOptionsRequest.builder().apply(block).build())

    /**
     * Updates the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html" target="_blank">Configuring Domain Endpoint Options in the Amazon CloudSearch Developer Guide.
     */
    suspend fun updateDomainEndpointOptions(input: UpdateDomainEndpointOptionsRequest): UpdateDomainEndpointOptionsResponse

    /**
     * Updates the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html" target="_blank">Configuring Domain Endpoint Options in the Amazon CloudSearch Developer Guide.
     */
    suspend fun updateDomainEndpointOptions(block: UpdateDomainEndpointOptionsRequest.DslBuilder.() -> Unit) = updateDomainEndpointOptions(UpdateDomainEndpointOptionsRequest.builder().apply(block).build())

    /**
     * Configures scaling parameters for a domain. A domain's scaling parameters specify the desired search instance type and replication count. Amazon CloudSearch will still automatically scale your domain based on the volume of data and traffic, but not below the desired instance type and replication count. If the Multi-AZ option is enabled, these values control the resources used per Availability Zone. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html" target="_blank">Configuring Scaling Options in the Amazon CloudSearch Developer Guide.
     */
    suspend fun updateScalingParameters(input: UpdateScalingParametersRequest): UpdateScalingParametersResponse

    /**
     * Configures scaling parameters for a domain. A domain's scaling parameters specify the desired search instance type and replication count. Amazon CloudSearch will still automatically scale your domain based on the volume of data and traffic, but not below the desired instance type and replication count. If the Multi-AZ option is enabled, these values control the resources used per Availability Zone. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html" target="_blank">Configuring Scaling Options in the Amazon CloudSearch Developer Guide.
     */
    suspend fun updateScalingParameters(block: UpdateScalingParametersRequest.DslBuilder.() -> Unit) = updateScalingParameters(UpdateScalingParametersRequest.builder().apply(block).build())

    /**
     * Configures the access rules that control access to the domain's document and search endpoints.
     * For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html" target="_blank">
     * Configuring Access for an Amazon CloudSearch Domain.
     */
    suspend fun updateServiceAccessPolicies(input: UpdateServiceAccessPoliciesRequest): UpdateServiceAccessPoliciesResponse

    /**
     * Configures the access rules that control access to the domain's document and search endpoints.
     * For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html" target="_blank">
     * Configuring Access for an Amazon CloudSearch Domain.
     */
    suspend fun updateServiceAccessPolicies(block: UpdateServiceAccessPoliciesRequest.DslBuilder.() -> Unit) = updateServiceAccessPolicies(UpdateServiceAccessPoliciesRequest.builder().apply(block).build())
}
