// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsmv2.paginators

import aws.sdk.kotlin.services.cloudhsmv2.CloudHsmV2Client
import aws.sdk.kotlin.services.cloudhsmv2.model.DescribeBackupsRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.DescribeBackupsResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.DescribeClustersRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.DescribeClustersResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.ListTagsRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.ListTagsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeBackupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeBackupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBackupsResponse]
 */
public fun CloudHsmV2Client.describeBackupsPaginated(initialRequest: DescribeBackupsRequest): Flow<DescribeBackupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeBackupsPaginated.describeBackups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeBackupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBackupsResponse]
 */
public fun CloudHsmV2Client.describeBackupsPaginated(block: DescribeBackupsRequest.Builder.() -> Unit): Flow<DescribeBackupsResponse> =
    describeBackupsPaginated(DescribeBackupsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClustersResponse]
 */
public fun CloudHsmV2Client.describeClustersPaginated(initialRequest: DescribeClustersRequest): Flow<DescribeClustersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeClustersPaginated.describeClusters(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClustersResponse]
 */
public fun CloudHsmV2Client.describeClustersPaginated(block: DescribeClustersRequest.Builder.() -> Unit): Flow<DescribeClustersResponse> =
    describeClustersPaginated(DescribeClustersRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsResponse]
 */
public fun CloudHsmV2Client.listTagsPaginated(initialRequest: ListTagsRequest): Flow<ListTagsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsPaginated.listTags(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsResponse]
 */
public fun CloudHsmV2Client.listTagsPaginated(block: ListTagsRequest.Builder.() -> Unit): Flow<ListTagsResponse> =
    listTagsPaginated(ListTagsRequest.Builder().apply(block).build())
