// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsmv2.model



/**
 * Contains information about a hardware security module (HSM) in an AWS CloudHSM cluster.
 */
public class Hsm private constructor(builder: Builder) {
    /**
     * The Availability Zone that contains the HSM.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The identifier (ID) of the cluster that contains the HSM.
     */
    public val clusterId: kotlin.String? = builder.clusterId
    /**
     * The identifier (ID) of the HSM's elastic network interface (ENI).
     */
    public val eniId: kotlin.String? = builder.eniId
    /**
     * The IP address of the HSM's elastic network interface (ENI).
     */
    public val eniIp: kotlin.String? = builder.eniIp
    /**
     * The HSM's identifier (ID).
     */
    public val hsmId: kotlin.String? = builder.hsmId
    /**
     * The HSM's state.
     */
    public val state: aws.sdk.kotlin.services.cloudhsmv2.model.HsmState? = builder.state
    /**
     * A description of the HSM's state.
     */
    public val stateMessage: kotlin.String? = builder.stateMessage
    /**
     * The subnet that contains the HSM's elastic network interface (ENI).
     */
    public val subnetId: kotlin.String? = builder.subnetId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudhsmv2.model.Hsm = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Hsm(")
        append("availabilityZone=$availabilityZone,")
        append("clusterId=$clusterId,")
        append("eniId=$eniId,")
        append("eniIp=$eniIp,")
        append("hsmId=$hsmId,")
        append("state=$state,")
        append("stateMessage=$stateMessage,")
        append("subnetId=$subnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (clusterId?.hashCode() ?: 0)
        result = 31 * result + (eniId?.hashCode() ?: 0)
        result = 31 * result + (eniIp?.hashCode() ?: 0)
        result = 31 * result + (hsmId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateMessage?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Hsm

        if (availabilityZone != other.availabilityZone) return false
        if (clusterId != other.clusterId) return false
        if (eniId != other.eniId) return false
        if (eniIp != other.eniIp) return false
        if (hsmId != other.hsmId) return false
        if (state != other.state) return false
        if (stateMessage != other.stateMessage) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudhsmv2.model.Hsm = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Availability Zone that contains the HSM.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The identifier (ID) of the cluster that contains the HSM.
         */
        public var clusterId: kotlin.String? = null
        /**
         * The identifier (ID) of the HSM's elastic network interface (ENI).
         */
        public var eniId: kotlin.String? = null
        /**
         * The IP address of the HSM's elastic network interface (ENI).
         */
        public var eniIp: kotlin.String? = null
        /**
         * The HSM's identifier (ID).
         */
        public var hsmId: kotlin.String? = null
        /**
         * The HSM's state.
         */
        public var state: aws.sdk.kotlin.services.cloudhsmv2.model.HsmState? = null
        /**
         * A description of the HSM's state.
         */
        public var stateMessage: kotlin.String? = null
        /**
         * The subnet that contains the HSM's elastic network interface (ENI).
         */
        public var subnetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudhsmv2.model.Hsm) : this() {
            this.availabilityZone = x.availabilityZone
            this.clusterId = x.clusterId
            this.eniId = x.eniId
            this.eniIp = x.eniIp
            this.hsmId = x.hsmId
            this.state = x.state
            this.stateMessage = x.stateMessage
            this.subnetId = x.subnetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudhsmv2.model.Hsm = Hsm(this)
    }
}
