// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsmv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an AWS CloudHSM cluster.
 */
public class Cluster private constructor(builder: Builder) {
    /**
     * The cluster's backup policy.
     */
    public val backupPolicy: aws.sdk.kotlin.services.cloudhsmv2.model.BackupPolicy? = builder.backupPolicy
    /**
     * A policy that defines how the service retains backups.
     */
    public val backupRetentionPolicy: aws.sdk.kotlin.services.cloudhsmv2.model.BackupRetentionPolicy? = builder.backupRetentionPolicy
    /**
     * Contains one or more certificates or a certificate signing request (CSR).
     */
    public val certificates: aws.sdk.kotlin.services.cloudhsmv2.model.Certificates? = builder.certificates
    /**
     * The cluster's identifier (ID).
     */
    public val clusterId: kotlin.String? = builder.clusterId
    /**
     * The date and time when the cluster was created.
     */
    public val createTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createTimestamp
    /**
     * The type of HSM that the cluster contains.
     */
    public val hsmType: kotlin.String? = builder.hsmType
    /**
     * Contains information about the HSMs in the cluster.
     */
    public val hsms: List<Hsm>? = builder.hsms
    /**
     * The default password for the cluster's Pre-Crypto Officer (PRECO) user.
     */
    public val preCoPassword: kotlin.String? = builder.preCoPassword
    /**
     * The identifier (ID) of the cluster's security group.
     */
    public val securityGroup: kotlin.String? = builder.securityGroup
    /**
     * The identifier (ID) of the backup used to create the cluster. This value exists only when the cluster was created from a backup.
     */
    public val sourceBackupId: kotlin.String? = builder.sourceBackupId
    /**
     * The cluster's state.
     */
    public val state: aws.sdk.kotlin.services.cloudhsmv2.model.ClusterState? = builder.state
    /**
     * A description of the cluster's state.
     */
    public val stateMessage: kotlin.String? = builder.stateMessage
    /**
     * A map from availability zone to the cluster’s subnet in that availability zone.
     */
    public val subnetMapping: Map<String, String>? = builder.subnetMapping
    /**
     * The list of tags for the cluster.
     */
    public val tagList: List<Tag>? = builder.tagList
    /**
     * The identifier (ID) of the virtual private cloud (VPC) that contains the cluster.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudhsmv2.model.Cluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Cluster(")
        append("backupPolicy=$backupPolicy,")
        append("backupRetentionPolicy=$backupRetentionPolicy,")
        append("certificates=$certificates,")
        append("clusterId=$clusterId,")
        append("createTimestamp=$createTimestamp,")
        append("hsmType=$hsmType,")
        append("hsms=$hsms,")
        append("preCoPassword=$preCoPassword,")
        append("securityGroup=$securityGroup,")
        append("sourceBackupId=$sourceBackupId,")
        append("state=$state,")
        append("stateMessage=$stateMessage,")
        append("subnetMapping=$subnetMapping,")
        append("tagList=$tagList,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupPolicy?.hashCode() ?: 0
        result = 31 * result + (backupRetentionPolicy?.hashCode() ?: 0)
        result = 31 * result + (certificates?.hashCode() ?: 0)
        result = 31 * result + (clusterId?.hashCode() ?: 0)
        result = 31 * result + (createTimestamp?.hashCode() ?: 0)
        result = 31 * result + (hsmType?.hashCode() ?: 0)
        result = 31 * result + (hsms?.hashCode() ?: 0)
        result = 31 * result + (preCoPassword?.hashCode() ?: 0)
        result = 31 * result + (securityGroup?.hashCode() ?: 0)
        result = 31 * result + (sourceBackupId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateMessage?.hashCode() ?: 0)
        result = 31 * result + (subnetMapping?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Cluster

        if (backupPolicy != other.backupPolicy) return false
        if (backupRetentionPolicy != other.backupRetentionPolicy) return false
        if (certificates != other.certificates) return false
        if (clusterId != other.clusterId) return false
        if (createTimestamp != other.createTimestamp) return false
        if (hsmType != other.hsmType) return false
        if (hsms != other.hsms) return false
        if (preCoPassword != other.preCoPassword) return false
        if (securityGroup != other.securityGroup) return false
        if (sourceBackupId != other.sourceBackupId) return false
        if (state != other.state) return false
        if (stateMessage != other.stateMessage) return false
        if (subnetMapping != other.subnetMapping) return false
        if (tagList != other.tagList) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudhsmv2.model.Cluster = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The cluster's backup policy.
         */
        public var backupPolicy: aws.sdk.kotlin.services.cloudhsmv2.model.BackupPolicy? = null
        /**
         * A policy that defines how the service retains backups.
         */
        public var backupRetentionPolicy: aws.sdk.kotlin.services.cloudhsmv2.model.BackupRetentionPolicy? = null
        /**
         * Contains one or more certificates or a certificate signing request (CSR).
         */
        public var certificates: aws.sdk.kotlin.services.cloudhsmv2.model.Certificates? = null
        /**
         * The cluster's identifier (ID).
         */
        public var clusterId: kotlin.String? = null
        /**
         * The date and time when the cluster was created.
         */
        public var createTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of HSM that the cluster contains.
         */
        public var hsmType: kotlin.String? = null
        /**
         * Contains information about the HSMs in the cluster.
         */
        public var hsms: List<Hsm>? = null
        /**
         * The default password for the cluster's Pre-Crypto Officer (PRECO) user.
         */
        public var preCoPassword: kotlin.String? = null
        /**
         * The identifier (ID) of the cluster's security group.
         */
        public var securityGroup: kotlin.String? = null
        /**
         * The identifier (ID) of the backup used to create the cluster. This value exists only when the cluster was created from a backup.
         */
        public var sourceBackupId: kotlin.String? = null
        /**
         * The cluster's state.
         */
        public var state: aws.sdk.kotlin.services.cloudhsmv2.model.ClusterState? = null
        /**
         * A description of the cluster's state.
         */
        public var stateMessage: kotlin.String? = null
        /**
         * A map from availability zone to the cluster’s subnet in that availability zone.
         */
        public var subnetMapping: Map<String, String>? = null
        /**
         * The list of tags for the cluster.
         */
        public var tagList: List<Tag>? = null
        /**
         * The identifier (ID) of the virtual private cloud (VPC) that contains the cluster.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudhsmv2.model.Cluster) : this() {
            this.backupPolicy = x.backupPolicy
            this.backupRetentionPolicy = x.backupRetentionPolicy
            this.certificates = x.certificates
            this.clusterId = x.clusterId
            this.createTimestamp = x.createTimestamp
            this.hsmType = x.hsmType
            this.hsms = x.hsms
            this.preCoPassword = x.preCoPassword
            this.securityGroup = x.securityGroup
            this.sourceBackupId = x.sourceBackupId
            this.state = x.state
            this.stateMessage = x.stateMessage
            this.subnetMapping = x.subnetMapping
            this.tagList = x.tagList
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudhsmv2.model.Cluster = Cluster(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudhsmv2.model.BackupRetentionPolicy] inside the given [block]
         */
        public fun backupRetentionPolicy(block: aws.sdk.kotlin.services.cloudhsmv2.model.BackupRetentionPolicy.Builder.() -> kotlin.Unit) {
            this.backupRetentionPolicy = aws.sdk.kotlin.services.cloudhsmv2.model.BackupRetentionPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudhsmv2.model.Certificates] inside the given [block]
         */
        public fun certificates(block: aws.sdk.kotlin.services.cloudhsmv2.model.Certificates.Builder.() -> kotlin.Unit) {
            this.certificates = aws.sdk.kotlin.services.cloudhsmv2.model.Certificates.invoke(block)
        }
    }
}
