// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsmv2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.cloudhsmv2.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.cloudhsmv2.model.*
import aws.sdk.kotlin.services.cloudhsmv2.model.CopyBackupToRegionRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.CopyBackupToRegionResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.CreateClusterRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.CreateClusterResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.CreateHsmRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.CreateHsmResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.DeleteBackupRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.DeleteBackupResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.DeleteClusterRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.DeleteClusterResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.DeleteHsmRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.DeleteHsmResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.DescribeBackupsRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.DescribeBackupsResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.DescribeClustersRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.DescribeClustersResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.InitializeClusterRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.InitializeClusterResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.ListTagsRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.ListTagsResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.ModifyBackupAttributesRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.ModifyBackupAttributesResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.ModifyClusterRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.ModifyClusterResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.RestoreBackupRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.RestoreBackupResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.TagResourceRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.TagResourceResponse
import aws.sdk.kotlin.services.cloudhsmv2.model.UntagResourceRequest
import aws.sdk.kotlin.services.cloudhsmv2.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * For more information about AWS CloudHSM, see [AWS CloudHSM](http://aws.amazon.com/cloudhsm/) and the [AWS CloudHSM User Guide](https://docs.aws.amazon.com/cloudhsm/latest/userguide/).
 */
public interface CloudHsmV2Client : SdkClient {

    override val serviceName: String
        get() = "CloudHSM V2"
    /**
     * CloudHsmV2Client's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): CloudHsmV2Client {
            val config = Config.Builder().apply(block).build()
            return DefaultCloudHsmV2Client(config)
        }

        public operator fun invoke(config: Config): CloudHsmV2Client = DefaultCloudHsmV2Client(config)

        /**
         * Construct a [CloudHsmV2Client] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CloudHsmV2Client {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultCloudHsmV2Client(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Copy an AWS CloudHSM cluster backup to a different region.
     */
    public suspend fun copyBackupToRegion(input: CopyBackupToRegionRequest): CopyBackupToRegionResponse

    /**
     * Creates a new AWS CloudHSM cluster.
     */
    public suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates a new hardware security module (HSM) in the specified AWS CloudHSM cluster.
     */
    public suspend fun createHsm(input: CreateHsmRequest): CreateHsmResponse

    /**
     * Deletes a specified AWS CloudHSM backup. A backup can be restored up to 7 days after the DeleteBackup request is made. For more information on restoring a backup, see RestoreBackup.
     */
    public suspend fun deleteBackup(input: DeleteBackupRequest): DeleteBackupResponse

    /**
     * Deletes the specified AWS CloudHSM cluster. Before you can delete a cluster, you must delete all HSMs in the cluster. To see if the cluster contains any HSMs, use DescribeClusters. To delete an HSM, use DeleteHsm.
     */
    public suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes the specified HSM. To specify an HSM, you can use its identifier (ID), the IP address of the HSM's elastic network interface (ENI), or the ID of the HSM's ENI. You need to specify only one of these values. To find these values, use DescribeClusters.
     */
    public suspend fun deleteHsm(input: DeleteHsmRequest): DeleteHsmResponse

    /**
     * Gets information about backups of AWS CloudHSM clusters.
     *
     * This is a paginated operation, which means that each response might contain only a subset of all the backups. When the response contains only a subset of backups, it includes a `NextToken` value. Use this value in a subsequent `DescribeBackups` request to get more backups. When you receive a response with no `NextToken` (or an empty or null value), that means there are no more backups to get.
     */
    public suspend fun describeBackups(input: DescribeBackupsRequest = DescribeBackupsRequest {}): DescribeBackupsResponse

    /**
     * Gets information about AWS CloudHSM clusters.
     *
     * This is a paginated operation, which means that each response might contain only a subset of all the clusters. When the response contains only a subset of clusters, it includes a `NextToken` value. Use this value in a subsequent `DescribeClusters` request to get more clusters. When you receive a response with no `NextToken` (or an empty or null value), that means there are no more clusters to get.
     */
    public suspend fun describeClusters(input: DescribeClustersRequest = DescribeClustersRequest {}): DescribeClustersResponse

    /**
     * Claims an AWS CloudHSM cluster by submitting the cluster certificate issued by your issuing certificate authority (CA) and the CA's root certificate. Before you can claim a cluster, you must sign the cluster's certificate signing request (CSR) with your issuing CA. To get the cluster's CSR, use DescribeClusters.
     */
    public suspend fun initializeCluster(input: InitializeClusterRequest): InitializeClusterResponse

    /**
     * Gets a list of tags for the specified AWS CloudHSM cluster.
     *
     * This is a paginated operation, which means that each response might contain only a subset of all the tags. When the response contains only a subset of tags, it includes a `NextToken` value. Use this value in a subsequent `ListTags` request to get more tags. When you receive a response with no `NextToken` (or an empty or null value), that means there are no more tags to get.
     */
    public suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Modifies attributes for AWS CloudHSM backup.
     */
    public suspend fun modifyBackupAttributes(input: ModifyBackupAttributesRequest): ModifyBackupAttributesResponse

    /**
     * Modifies AWS CloudHSM cluster.
     */
    public suspend fun modifyCluster(input: ModifyClusterRequest): ModifyClusterResponse

    /**
     * Restores a specified AWS CloudHSM backup that is in the `PENDING_DELETION` state. For mor information on deleting a backup, see DeleteBackup.
     */
    public suspend fun restoreBackup(input: RestoreBackupRequest): RestoreBackupResponse

    /**
     * Adds or overwrites one or more tags for the specified AWS CloudHSM cluster.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tag or tags from the specified AWS CloudHSM cluster.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Copy an AWS CloudHSM cluster backup to a different region.
 */
public suspend inline fun CloudHsmV2Client.copyBackupToRegion(crossinline block: CopyBackupToRegionRequest.Builder.() -> Unit): CopyBackupToRegionResponse = copyBackupToRegion(CopyBackupToRegionRequest.Builder().apply(block).build())

/**
 * Creates a new AWS CloudHSM cluster.
 */
public suspend inline fun CloudHsmV2Client.createCluster(crossinline block: CreateClusterRequest.Builder.() -> Unit): CreateClusterResponse = createCluster(CreateClusterRequest.Builder().apply(block).build())

/**
 * Creates a new hardware security module (HSM) in the specified AWS CloudHSM cluster.
 */
public suspend inline fun CloudHsmV2Client.createHsm(crossinline block: CreateHsmRequest.Builder.() -> Unit): CreateHsmResponse = createHsm(CreateHsmRequest.Builder().apply(block).build())

/**
 * Deletes a specified AWS CloudHSM backup. A backup can be restored up to 7 days after the DeleteBackup request is made. For more information on restoring a backup, see RestoreBackup.
 */
public suspend inline fun CloudHsmV2Client.deleteBackup(crossinline block: DeleteBackupRequest.Builder.() -> Unit): DeleteBackupResponse = deleteBackup(DeleteBackupRequest.Builder().apply(block).build())

/**
 * Deletes the specified AWS CloudHSM cluster. Before you can delete a cluster, you must delete all HSMs in the cluster. To see if the cluster contains any HSMs, use DescribeClusters. To delete an HSM, use DeleteHsm.
 */
public suspend inline fun CloudHsmV2Client.deleteCluster(crossinline block: DeleteClusterRequest.Builder.() -> Unit): DeleteClusterResponse = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

/**
 * Deletes the specified HSM. To specify an HSM, you can use its identifier (ID), the IP address of the HSM's elastic network interface (ENI), or the ID of the HSM's ENI. You need to specify only one of these values. To find these values, use DescribeClusters.
 */
public suspend inline fun CloudHsmV2Client.deleteHsm(crossinline block: DeleteHsmRequest.Builder.() -> Unit): DeleteHsmResponse = deleteHsm(DeleteHsmRequest.Builder().apply(block).build())

/**
 * Gets information about backups of AWS CloudHSM clusters.
 *
 * This is a paginated operation, which means that each response might contain only a subset of all the backups. When the response contains only a subset of backups, it includes a `NextToken` value. Use this value in a subsequent `DescribeBackups` request to get more backups. When you receive a response with no `NextToken` (or an empty or null value), that means there are no more backups to get.
 */
public suspend inline fun CloudHsmV2Client.describeBackups(crossinline block: DescribeBackupsRequest.Builder.() -> Unit): DescribeBackupsResponse = describeBackups(DescribeBackupsRequest.Builder().apply(block).build())

/**
 * Gets information about AWS CloudHSM clusters.
 *
 * This is a paginated operation, which means that each response might contain only a subset of all the clusters. When the response contains only a subset of clusters, it includes a `NextToken` value. Use this value in a subsequent `DescribeClusters` request to get more clusters. When you receive a response with no `NextToken` (or an empty or null value), that means there are no more clusters to get.
 */
public suspend inline fun CloudHsmV2Client.describeClusters(crossinline block: DescribeClustersRequest.Builder.() -> Unit): DescribeClustersResponse = describeClusters(DescribeClustersRequest.Builder().apply(block).build())

/**
 * Claims an AWS CloudHSM cluster by submitting the cluster certificate issued by your issuing certificate authority (CA) and the CA's root certificate. Before you can claim a cluster, you must sign the cluster's certificate signing request (CSR) with your issuing CA. To get the cluster's CSR, use DescribeClusters.
 */
public suspend inline fun CloudHsmV2Client.initializeCluster(crossinline block: InitializeClusterRequest.Builder.() -> Unit): InitializeClusterResponse = initializeCluster(InitializeClusterRequest.Builder().apply(block).build())

/**
 * Gets a list of tags for the specified AWS CloudHSM cluster.
 *
 * This is a paginated operation, which means that each response might contain only a subset of all the tags. When the response contains only a subset of tags, it includes a `NextToken` value. Use this value in a subsequent `ListTags` request to get more tags. When you receive a response with no `NextToken` (or an empty or null value), that means there are no more tags to get.
 */
public suspend inline fun CloudHsmV2Client.listTags(crossinline block: ListTagsRequest.Builder.() -> Unit): ListTagsResponse = listTags(ListTagsRequest.Builder().apply(block).build())

/**
 * Modifies attributes for AWS CloudHSM backup.
 */
public suspend inline fun CloudHsmV2Client.modifyBackupAttributes(crossinline block: ModifyBackupAttributesRequest.Builder.() -> Unit): ModifyBackupAttributesResponse = modifyBackupAttributes(ModifyBackupAttributesRequest.Builder().apply(block).build())

/**
 * Modifies AWS CloudHSM cluster.
 */
public suspend inline fun CloudHsmV2Client.modifyCluster(crossinline block: ModifyClusterRequest.Builder.() -> Unit): ModifyClusterResponse = modifyCluster(ModifyClusterRequest.Builder().apply(block).build())

/**
 * Restores a specified AWS CloudHSM backup that is in the `PENDING_DELETION` state. For mor information on deleting a backup, see DeleteBackup.
 */
public suspend inline fun CloudHsmV2Client.restoreBackup(crossinline block: RestoreBackupRequest.Builder.() -> Unit): RestoreBackupResponse = restoreBackup(RestoreBackupRequest.Builder().apply(block).build())

/**
 * Adds or overwrites one or more tags for the specified AWS CloudHSM cluster.
 */
public suspend inline fun CloudHsmV2Client.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tag or tags from the specified AWS CloudHSM cluster.
 */
public suspend inline fun CloudHsmV2Client.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
