// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsmv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudhsmv2.model.CloudHsmV2Exception
import aws.sdk.kotlin.services.cloudhsmv2.model.Cluster
import aws.sdk.kotlin.services.cloudhsmv2.model.CreateClusterResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateClusterOperationDeserializer: HttpDeserialize<CreateClusterResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateClusterResponse {
        if (!response.status.isSuccess()) {
            throwCreateClusterError(context, response)
        }
        val builder = CreateClusterResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateClusterOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateClusterError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudHsmV2Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CloudHsmAccessDeniedException" -> CloudHsmAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "CloudHsmInternalFailureException" -> CloudHsmInternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "CloudHsmInvalidRequestException" -> CloudHsmInvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "CloudHsmResourceNotFoundException" -> CloudHsmResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "CloudHsmServiceException" -> CloudHsmServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "CloudHsmTagException" -> CloudHsmTagExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudHsmV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateClusterOperationBody(builder: CreateClusterResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLUSTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Cluster"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLUSTER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTER_DESCRIPTOR.index -> builder.cluster = deserializeClusterDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
