// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsmv2.model



public class DescribeBackupsRequest private constructor(builder: Builder) {
    /**
     * One or more filters to limit the items returned in the response.
     *
     * Use the `backupIds` filter to return only the specified backups. Specify backups by their backup identifier (ID).
     *
     * Use the `sourceBackupIds` filter to return only the backups created from a source backup. The `sourceBackupID` of a source backup is returned by the CopyBackupToRegion operation.
     *
     * Use the `clusterIds` filter to return only the backups for the specified clusters. Specify clusters by their cluster identifier (ID).
     *
     * Use the `states` filter to return only backups that match the specified state.
     *
     * Use the `neverExpires` filter to return backups filtered by the value in the `neverExpires` parameter. `True` returns all backups exempt from the backup retention policy. `False` returns all backups with a backup retention policy defined at the cluster.
     */
    public val filters: Map<String, List<String>>? = builder.filters
    /**
     * The maximum number of backups to return in the response. When there are more backups than the number you specify, the response contains a `NextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `NextToken` value that you received in the previous response. Use this value to get more backups.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Designates whether or not to sort the return backups by ascending chronological order of generation.
     */
    public val sortAscending: kotlin.Boolean? = builder.sortAscending

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudhsmv2.model.DescribeBackupsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeBackupsRequest(")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortAscending=$sortAscending)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortAscending?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeBackupsRequest

        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortAscending != other.sortAscending) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudhsmv2.model.DescribeBackupsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * One or more filters to limit the items returned in the response.
         *
         * Use the `backupIds` filter to return only the specified backups. Specify backups by their backup identifier (ID).
         *
         * Use the `sourceBackupIds` filter to return only the backups created from a source backup. The `sourceBackupID` of a source backup is returned by the CopyBackupToRegion operation.
         *
         * Use the `clusterIds` filter to return only the backups for the specified clusters. Specify clusters by their cluster identifier (ID).
         *
         * Use the `states` filter to return only backups that match the specified state.
         *
         * Use the `neverExpires` filter to return backups filtered by the value in the `neverExpires` parameter. `True` returns all backups exempt from the backup retention policy. `False` returns all backups with a backup retention policy defined at the cluster.
         */
        public var filters: Map<String, List<String>>? = null
        /**
         * The maximum number of backups to return in the response. When there are more backups than the number you specify, the response contains a `NextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `NextToken` value that you received in the previous response. Use this value to get more backups.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Designates whether or not to sort the return backups by ascending chronological order of generation.
         */
        public var sortAscending: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudhsmv2.model.DescribeBackupsRequest) : this() {
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortAscending = x.sortAscending
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudhsmv2.model.DescribeBackupsRequest = DescribeBackupsRequest(this)
    }
}
