// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsmv2.model



public class CreateClusterRequest private constructor(builder: Builder) {
    /**
     * A policy that defines how the service retains backups.
     */
    public val backupRetentionPolicy: aws.sdk.kotlin.services.cloudhsmv2.model.BackupRetentionPolicy? = builder.backupRetentionPolicy
    /**
     * The type of HSM to use in the cluster. Currently the only allowed value is `hsm1.medium`.
     */
    public val hsmType: kotlin.String? = builder.hsmType
    /**
     * The identifier (ID) of the cluster backup to restore. Use this value to restore the cluster from a backup instead of creating a new cluster. To find the backup ID, use DescribeBackups.
     */
    public val sourceBackupId: kotlin.String? = builder.sourceBackupId
    /**
     * The identifiers (IDs) of the subnets where you are creating the cluster. You must specify at least one subnet. If you specify multiple subnets, they must meet the following criteria:
     * + All subnets must be in the same virtual private cloud (VPC).
     * + You can specify only one subnet per Availability Zone.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * Tags to apply to the CloudHSM cluster during creation.
     */
    public val tagList: List<Tag>? = builder.tagList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudhsmv2.model.CreateClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClusterRequest(")
        append("backupRetentionPolicy=$backupRetentionPolicy,")
        append("hsmType=$hsmType,")
        append("sourceBackupId=$sourceBackupId,")
        append("subnetIds=$subnetIds,")
        append("tagList=$tagList)")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupRetentionPolicy?.hashCode() ?: 0
        result = 31 * result + (hsmType?.hashCode() ?: 0)
        result = 31 * result + (sourceBackupId?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateClusterRequest

        if (backupRetentionPolicy != other.backupRetentionPolicy) return false
        if (hsmType != other.hsmType) return false
        if (sourceBackupId != other.sourceBackupId) return false
        if (subnetIds != other.subnetIds) return false
        if (tagList != other.tagList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudhsmv2.model.CreateClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A policy that defines how the service retains backups.
         */
        public var backupRetentionPolicy: aws.sdk.kotlin.services.cloudhsmv2.model.BackupRetentionPolicy? = null
        /**
         * The type of HSM to use in the cluster. Currently the only allowed value is `hsm1.medium`.
         */
        public var hsmType: kotlin.String? = null
        /**
         * The identifier (ID) of the cluster backup to restore. Use this value to restore the cluster from a backup instead of creating a new cluster. To find the backup ID, use DescribeBackups.
         */
        public var sourceBackupId: kotlin.String? = null
        /**
         * The identifiers (IDs) of the subnets where you are creating the cluster. You must specify at least one subnet. If you specify multiple subnets, they must meet the following criteria:
         * + All subnets must be in the same virtual private cloud (VPC).
         * + You can specify only one subnet per Availability Zone.
         */
        public var subnetIds: List<String>? = null
        /**
         * Tags to apply to the CloudHSM cluster during creation.
         */
        public var tagList: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudhsmv2.model.CreateClusterRequest) : this() {
            this.backupRetentionPolicy = x.backupRetentionPolicy
            this.hsmType = x.hsmType
            this.sourceBackupId = x.sourceBackupId
            this.subnetIds = x.subnetIds
            this.tagList = x.tagList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudhsmv2.model.CreateClusterRequest = CreateClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudhsmv2.model.BackupRetentionPolicy] inside the given [block]
         */
        public fun backupRetentionPolicy(block: aws.sdk.kotlin.services.cloudhsmv2.model.BackupRetentionPolicy.Builder.() -> kotlin.Unit) {
            this.backupRetentionPolicy = aws.sdk.kotlin.services.cloudhsmv2.model.BackupRetentionPolicy.invoke(block)
        }
    }
}
