// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsmv2.serde

import aws.sdk.kotlin.services.cloudhsmv2.model.CloudHsmV2Exception
import aws.sdk.kotlin.services.cloudhsmv2.model.ClusterState
import aws.sdk.kotlin.services.cloudhsmv2.model.InitializeClusterResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class InitializeClusterOperationDeserializer: HttpDeserializer.NonStreaming<InitializeClusterResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): InitializeClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwInitializeClusterError(context, call, payload)
        }
        val builder = InitializeClusterResponse.Builder()

        if (payload != null) {
            deserializeInitializeClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwInitializeClusterError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudHsmV2Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CloudHsmAccessDeniedException" -> CloudHsmAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmInternalFailureException" -> CloudHsmInternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmInvalidRequestException" -> CloudHsmInvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmResourceNotFoundException" -> CloudHsmResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmServiceException" -> CloudHsmServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudHsmV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeInitializeClusterOperationBody(builder: InitializeClusterResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val STATEMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StateMessage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(STATE_DESCRIPTOR)
        field(STATEMESSAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { ClusterState.fromValue(it) }
                STATEMESSAGE_DESCRIPTOR.index -> builder.stateMessage = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
