// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsmv2.serde

import aws.sdk.kotlin.services.cloudhsmv2.model.Backup
import aws.sdk.kotlin.services.cloudhsmv2.model.CloudHsmV2Exception
import aws.sdk.kotlin.services.cloudhsmv2.model.DescribeBackupsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeBackupsOperationDeserializer: HttpDeserializer.NonStreaming<DescribeBackupsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeBackupsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeBackupsError(context, call, payload)
        }
        val builder = DescribeBackupsResponse.Builder()

        if (payload != null) {
            deserializeDescribeBackupsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeBackupsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudHsmV2Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CloudHsmAccessDeniedException" -> CloudHsmAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmInternalFailureException" -> CloudHsmInternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmInvalidRequestException" -> CloudHsmInvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmResourceNotFoundException" -> CloudHsmResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmServiceException" -> CloudHsmServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmTagException" -> CloudHsmTagExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudHsmV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeBackupsOperationBody(builder: DescribeBackupsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BACKUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Backups"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BACKUPS_DESCRIPTOR.index -> builder.backups =
                    deserializer.deserializeList(BACKUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<Backup>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBackupDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
