// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsmv2.serde

import aws.sdk.kotlin.services.cloudhsmv2.model.Backup
import aws.sdk.kotlin.services.cloudhsmv2.model.CloudHsmV2Exception
import aws.sdk.kotlin.services.cloudhsmv2.model.RestoreBackupResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RestoreBackupOperationDeserializer: HttpDeserializer.NonStreaming<RestoreBackupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): RestoreBackupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRestoreBackupError(context, call, payload)
        }
        val builder = RestoreBackupResponse.Builder()

        if (payload != null) {
            deserializeRestoreBackupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwRestoreBackupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudHsmV2Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CloudHsmAccessDeniedException" -> CloudHsmAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmInternalFailureException" -> CloudHsmInternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmInvalidRequestException" -> CloudHsmInvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmResourceNotFoundException" -> CloudHsmResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmServiceException" -> CloudHsmServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudHsmV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRestoreBackupOperationBody(builder: RestoreBackupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BACKUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Backup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BACKUP_DESCRIPTOR.index -> builder.backup = deserializeBackupDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
