// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsmv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains one or more certificates or a certificate signing request (CSR).
 */
public class Certificates private constructor(builder: Builder) {
    /**
     * The HSM hardware certificate issued (signed) by CloudHSM.
     */
    public val awsHardwareCertificate: kotlin.String? = builder.awsHardwareCertificate
    /**
     * The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's owner.
     */
    public val clusterCertificate: kotlin.String? = builder.clusterCertificate
    /**
     * The cluster's certificate signing request (CSR). The CSR exists only when the cluster's state is `UNINITIALIZED`.
     */
    public val clusterCsr: kotlin.String? = builder.clusterCsr
    /**
     * The HSM certificate issued (signed) by the HSM hardware.
     */
    public val hsmCertificate: kotlin.String? = builder.hsmCertificate
    /**
     * The HSM hardware certificate issued (signed) by the hardware manufacturer.
     */
    public val manufacturerHardwareCertificate: kotlin.String? = builder.manufacturerHardwareCertificate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudhsmv2.model.Certificates = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Certificates(")
        append("awsHardwareCertificate=$awsHardwareCertificate,")
        append("clusterCertificate=$clusterCertificate,")
        append("clusterCsr=$clusterCsr,")
        append("hsmCertificate=$hsmCertificate,")
        append("manufacturerHardwareCertificate=$manufacturerHardwareCertificate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsHardwareCertificate?.hashCode() ?: 0
        result = 31 * result + (clusterCertificate?.hashCode() ?: 0)
        result = 31 * result + (clusterCsr?.hashCode() ?: 0)
        result = 31 * result + (hsmCertificate?.hashCode() ?: 0)
        result = 31 * result + (manufacturerHardwareCertificate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Certificates

        if (awsHardwareCertificate != other.awsHardwareCertificate) return false
        if (clusterCertificate != other.clusterCertificate) return false
        if (clusterCsr != other.clusterCsr) return false
        if (hsmCertificate != other.hsmCertificate) return false
        if (manufacturerHardwareCertificate != other.manufacturerHardwareCertificate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudhsmv2.model.Certificates = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The HSM hardware certificate issued (signed) by CloudHSM.
         */
        public var awsHardwareCertificate: kotlin.String? = null
        /**
         * The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's owner.
         */
        public var clusterCertificate: kotlin.String? = null
        /**
         * The cluster's certificate signing request (CSR). The CSR exists only when the cluster's state is `UNINITIALIZED`.
         */
        public var clusterCsr: kotlin.String? = null
        /**
         * The HSM certificate issued (signed) by the HSM hardware.
         */
        public var hsmCertificate: kotlin.String? = null
        /**
         * The HSM hardware certificate issued (signed) by the hardware manufacturer.
         */
        public var manufacturerHardwareCertificate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudhsmv2.model.Certificates) : this() {
            this.awsHardwareCertificate = x.awsHardwareCertificate
            this.clusterCertificate = x.clusterCertificate
            this.clusterCsr = x.clusterCsr
            this.hsmCertificate = x.hsmCertificate
            this.manufacturerHardwareCertificate = x.manufacturerHardwareCertificate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudhsmv2.model.Certificates = Certificates(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
