// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudhsmv2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a backup of an CloudHSM cluster. All backup objects contain the `BackupId`, `BackupState`, `ClusterId`, and `CreateTimestamp` parameters. Backups that were copied into a destination region additionally contain the `CopyTimestamp`, `SourceBackup`, `SourceCluster`, and `SourceRegion` parameters. A backup that is pending deletion will include the `DeleteTimestamp` parameter.
 */
public class Backup private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the backup.
     */
    public val backupArn: kotlin.String? = builder.backupArn
    /**
     * The identifier (ID) of the backup.
     */
    public val backupId: kotlin.String = requireNotNull(builder.backupId) { "A non-null value must be provided for backupId" }
    /**
     * The state of the backup.
     */
    public val backupState: aws.sdk.kotlin.services.cloudhsmv2.model.BackupState? = builder.backupState
    /**
     * The identifier (ID) of the cluster that was backed up.
     */
    public val clusterId: kotlin.String? = builder.clusterId
    /**
     * The date and time when the backup was copied from a source backup.
     */
    public val copyTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.copyTimestamp
    /**
     * The date and time when the backup was created.
     */
    public val createTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createTimestamp
    /**
     * The date and time when the backup will be permanently deleted.
     */
    public val deleteTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.deleteTimestamp
    /**
     * The HSM type used to create the backup.
     */
    public val hsmType: kotlin.String? = builder.hsmType
    /**
     * The mode of the cluster that was backed up.
     */
    public val mode: aws.sdk.kotlin.services.cloudhsmv2.model.ClusterMode? = builder.mode
    /**
     * Specifies whether the service should exempt a backup from the retention policy for the cluster. `True` exempts a backup from the retention policy. `False` means the service applies the backup retention policy defined at the cluster.
     */
    public val neverExpires: kotlin.Boolean? = builder.neverExpires
    /**
     * The identifier (ID) of the source backup from which the new backup was copied.
     */
    public val sourceBackup: kotlin.String? = builder.sourceBackup
    /**
     * The identifier (ID) of the cluster containing the source backup from which the new backup was copied.
     */
    public val sourceCluster: kotlin.String? = builder.sourceCluster
    /**
     * The AWS Region that contains the source backup from which the new backup was copied.
     */
    public val sourceRegion: kotlin.String? = builder.sourceRegion
    /**
     * The list of tags for the backup.
     */
    public val tagList: List<Tag>? = builder.tagList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudhsmv2.model.Backup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Backup(")
        append("backupArn=$backupArn,")
        append("backupId=$backupId,")
        append("backupState=$backupState,")
        append("clusterId=$clusterId,")
        append("copyTimestamp=$copyTimestamp,")
        append("createTimestamp=$createTimestamp,")
        append("deleteTimestamp=$deleteTimestamp,")
        append("hsmType=$hsmType,")
        append("mode=$mode,")
        append("neverExpires=$neverExpires,")
        append("sourceBackup=$sourceBackup,")
        append("sourceCluster=$sourceCluster,")
        append("sourceRegion=$sourceRegion,")
        append("tagList=$tagList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupArn?.hashCode() ?: 0
        result = 31 * result + (backupId.hashCode())
        result = 31 * result + (backupState?.hashCode() ?: 0)
        result = 31 * result + (clusterId?.hashCode() ?: 0)
        result = 31 * result + (copyTimestamp?.hashCode() ?: 0)
        result = 31 * result + (createTimestamp?.hashCode() ?: 0)
        result = 31 * result + (deleteTimestamp?.hashCode() ?: 0)
        result = 31 * result + (hsmType?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (neverExpires?.hashCode() ?: 0)
        result = 31 * result + (sourceBackup?.hashCode() ?: 0)
        result = 31 * result + (sourceCluster?.hashCode() ?: 0)
        result = 31 * result + (sourceRegion?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Backup

        if (backupArn != other.backupArn) return false
        if (backupId != other.backupId) return false
        if (backupState != other.backupState) return false
        if (clusterId != other.clusterId) return false
        if (copyTimestamp != other.copyTimestamp) return false
        if (createTimestamp != other.createTimestamp) return false
        if (deleteTimestamp != other.deleteTimestamp) return false
        if (hsmType != other.hsmType) return false
        if (mode != other.mode) return false
        if (neverExpires != other.neverExpires) return false
        if (sourceBackup != other.sourceBackup) return false
        if (sourceCluster != other.sourceCluster) return false
        if (sourceRegion != other.sourceRegion) return false
        if (tagList != other.tagList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudhsmv2.model.Backup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the backup.
         */
        public var backupArn: kotlin.String? = null
        /**
         * The identifier (ID) of the backup.
         */
        public var backupId: kotlin.String? = null
        /**
         * The state of the backup.
         */
        public var backupState: aws.sdk.kotlin.services.cloudhsmv2.model.BackupState? = null
        /**
         * The identifier (ID) of the cluster that was backed up.
         */
        public var clusterId: kotlin.String? = null
        /**
         * The date and time when the backup was copied from a source backup.
         */
        public var copyTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time when the backup was created.
         */
        public var createTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time when the backup will be permanently deleted.
         */
        public var deleteTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The HSM type used to create the backup.
         */
        public var hsmType: kotlin.String? = null
        /**
         * The mode of the cluster that was backed up.
         */
        public var mode: aws.sdk.kotlin.services.cloudhsmv2.model.ClusterMode? = null
        /**
         * Specifies whether the service should exempt a backup from the retention policy for the cluster. `True` exempts a backup from the retention policy. `False` means the service applies the backup retention policy defined at the cluster.
         */
        public var neverExpires: kotlin.Boolean? = null
        /**
         * The identifier (ID) of the source backup from which the new backup was copied.
         */
        public var sourceBackup: kotlin.String? = null
        /**
         * The identifier (ID) of the cluster containing the source backup from which the new backup was copied.
         */
        public var sourceCluster: kotlin.String? = null
        /**
         * The AWS Region that contains the source backup from which the new backup was copied.
         */
        public var sourceRegion: kotlin.String? = null
        /**
         * The list of tags for the backup.
         */
        public var tagList: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudhsmv2.model.Backup) : this() {
            this.backupArn = x.backupArn
            this.backupId = x.backupId
            this.backupState = x.backupState
            this.clusterId = x.clusterId
            this.copyTimestamp = x.copyTimestamp
            this.createTimestamp = x.createTimestamp
            this.deleteTimestamp = x.deleteTimestamp
            this.hsmType = x.hsmType
            this.mode = x.mode
            this.neverExpires = x.neverExpires
            this.sourceBackup = x.sourceBackup
            this.sourceCluster = x.sourceCluster
            this.sourceRegion = x.sourceRegion
            this.tagList = x.tagList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudhsmv2.model.Backup = Backup(this)

        internal fun correctErrors(): Builder {
            if (backupId == null) backupId = ""
            return this
        }
    }
}
