// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.services.cloudfront.model.UpdateKeyGroupRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.serde.xml.XmlSerializer


internal class UpdateKeyGroupOperationSerializer: HttpSerialize<UpdateKeyGroupRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateKeyGroupRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "2020-05-31",
                "key-group",
                "${input.id}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        builder.headers {
            if (input.ifMatch?.isNotEmpty() == true) append("If-Match", input.ifMatch)
        }

        if (input.keyGroupConfig != null) {
            val payload = serializeUpdateKeyGroupOperationBody(context, input)
            builder.body = ByteArrayContent(payload)
        }
        builder.headers.setMissing("Content-Type", "application/xml")
        return builder
    }
}

private fun serializeUpdateKeyGroupOperationBody(context: ExecutionContext, input: UpdateKeyGroupRequest): ByteArray {
    val serializer = XmlSerializer()
    val input = requireNotNull(input.keyGroupConfig)
    val COMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Comment"))
    val ITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Items"), XmlCollectionName("PublicKey"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Name"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("KeyGroupConfig"))
        trait(XmlNamespace("http://cloudfront.amazonaws.com/doc/2020-05-31/"))
        field(COMMENT_DESCRIPTOR)
        field(ITEMS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.comment?.let { field(COMMENT_DESCRIPTOR, it) }
        if (input.items != null) {
            listField(ITEMS_DESCRIPTOR) {
                for (el0 in input.items) {
                    serializeString(el0)
                }
            }
        }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
