// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer


internal class UpdateFieldLevelEncryptionProfileOperationDeserializer: HttpDeserialize<UpdateFieldLevelEncryptionProfileResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateFieldLevelEncryptionProfileResponse {
        if (!response.status.isSuccess()) {
            throwUpdateFieldLevelEncryptionProfileError(context, response)
        }
        val builder = UpdateFieldLevelEncryptionProfileResponse.builder()

        builder.eTag = response.headers["ETag"]

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateFieldLevelEncryptionProfileOperationBody(builder, payload)
        }

        return builder.build()
    }
}

private suspend fun deserializeUpdateFieldLevelEncryptionProfileOperationBody(builder: UpdateFieldLevelEncryptionProfileResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    builder.fieldLevelEncryptionProfile = deserializeFieldLevelEncryptionProfileDocument(deserializer)
}

private suspend fun throwUpdateFieldLevelEncryptionProfileError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restXml error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer()
        "FieldLevelEncryptionProfileAlreadyExists" -> FieldLevelEncryptionProfileAlreadyExistsDeserializer()
        "FieldLevelEncryptionProfileSizeExceeded" -> FieldLevelEncryptionProfileSizeExceededDeserializer()
        "IllegalUpdate" -> IllegalUpdateDeserializer()
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer()
        "InvalidArgument" -> InvalidArgumentDeserializer()
        "InvalidIfMatchVersion" -> InvalidIfMatchVersionDeserializer()
        "NoSuchFieldLevelEncryptionProfile" -> NoSuchFieldLevelEncryptionProfileDeserializer()
        "NoSuchPublicKey" -> NoSuchPublicKeyDeserializer()
        "PreconditionFailed" -> PreconditionFailedDeserializer()
        "TooManyFieldLevelEncryptionEncryptionEntities" -> TooManyFieldLevelEncryptionEncryptionEntitiesDeserializer()
        "TooManyFieldLevelEncryptionFieldPatterns" -> TooManyFieldLevelEncryptionFieldPatternsDeserializer()
        else -> throw CloudFrontException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
