// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.services.cloudfront.model.TestFunctionRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.serde.xml.XmlSerializer
import aws.smithy.kotlin.runtime.util.encodeBase64String


internal class TestFunctionOperationSerializer: HttpSerialize<TestFunctionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: TestFunctionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "2020-05-31",
                "function",
                "${input.name}".encodeLabel(),
                "test",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        builder.headers {
            if (input.ifMatch?.isNotEmpty() == true) append("If-Match", input.ifMatch)
        }

        val payload = serializeTestFunctionOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/xml")
        return builder
    }
}

private fun serializeTestFunctionOperationBody(context: ExecutionContext, input: TestFunctionRequest): ByteArray {
    val serializer = XmlSerializer()
    val EVENTOBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, XmlSerialName("EventObject"))
    val STAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Stage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("TestFunctionRequest"))
        trait(XmlNamespace("http://cloudfront.amazonaws.com/doc/2020-05-31/"))
        field(EVENTOBJECT_DESCRIPTOR)
        field(STAGE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.eventObject?.let { field(EVENTOBJECT_DESCRIPTOR, it.encodeBase64String()) }
        input.stage?.let { field(STAGE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
