// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByKeyGroupResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer


internal class ListDistributionsByKeyGroupOperationDeserializer: HttpDeserialize<ListDistributionsByKeyGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListDistributionsByKeyGroupResponse {
        if (!response.status.isSuccess()) {
            throwListDistributionsByKeyGroupError(context, response)
        }
        val builder = ListDistributionsByKeyGroupResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListDistributionsByKeyGroupOperationBody(builder, payload)
        }

        return builder.build()
    }
}

private suspend fun deserializeListDistributionsByKeyGroupOperationBody(builder: ListDistributionsByKeyGroupResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    builder.distributionIdList = deserializeDistributionIdListDocument(deserializer)
}

private suspend fun throwListDistributionsByKeyGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restXml error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InvalidArgument" -> InvalidArgumentDeserializer()
        "NoSuchResource" -> NoSuchResourceDeserializer()
        else -> throw CloudFrontException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
