// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.DescribeFunctionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer


internal class DescribeFunctionOperationDeserializer: HttpDeserialize<DescribeFunctionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeFunctionResponse {
        if (!response.status.isSuccess()) {
            throwDescribeFunctionError(context, response)
        }
        val builder = DescribeFunctionResponse.builder()

        builder.eTag = response.headers["ETag"]

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeFunctionOperationBody(builder, payload)
        }

        return builder.build()
    }
}

private suspend fun deserializeDescribeFunctionOperationBody(builder: DescribeFunctionResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    builder.functionSummary = deserializeFunctionSummaryDocument(deserializer)
}

private suspend fun throwDescribeFunctionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restXml error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "NoSuchFunctionExists" -> NoSuchFunctionExistsDeserializer()
        "UnsupportedOperation" -> UnsupportedOperationDeserializer()
        else -> throw CloudFrontException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
