// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.services.cloudfront.model.CreateStreamingDistributionRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.serde.xml.XmlSerializer


internal class CreateStreamingDistributionOperationSerializer: HttpSerialize<CreateStreamingDistributionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateStreamingDistributionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/2020-05-31/streaming-distribution"
        }

        if (input.streamingDistributionConfig != null) {
            val payload = serializeCreateStreamingDistributionOperationBody(context, input)
            builder.body = ByteArrayContent(payload)
        }
        builder.headers.setMissing("Content-Type", "application/xml")
        return builder
    }
}

private fun serializeCreateStreamingDistributionOperationBody(context: ExecutionContext, input: CreateStreamingDistributionRequest): ByteArray {
    val serializer = XmlSerializer()
    val input = requireNotNull(input.streamingDistributionConfig)
    val ALIASES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Aliases"))
    val CALLERREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("CallerReference"))
    val COMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Comment"))
    val ENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("Enabled"))
    val LOGGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Logging"))
    val PRICECLASS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("PriceClass"))
    val S3ORIGIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("S3Origin"))
    val TRUSTEDSIGNERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("TrustedSigners"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("StreamingDistributionConfig"))
        trait(XmlNamespace("http://cloudfront.amazonaws.com/doc/2020-05-31/"))
        field(ALIASES_DESCRIPTOR)
        field(CALLERREFERENCE_DESCRIPTOR)
        field(COMMENT_DESCRIPTOR)
        field(ENABLED_DESCRIPTOR)
        field(LOGGING_DESCRIPTOR)
        field(PRICECLASS_DESCRIPTOR)
        field(S3ORIGIN_DESCRIPTOR)
        field(TRUSTEDSIGNERS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.aliases?.let { field(ALIASES_DESCRIPTOR, it, ::serializeAliasesDocument) }
        input.callerReference?.let { field(CALLERREFERENCE_DESCRIPTOR, it) }
        input.comment?.let { field(COMMENT_DESCRIPTOR, it) }
        input.enabled?.let { field(ENABLED_DESCRIPTOR, it) }
        input.logging?.let { field(LOGGING_DESCRIPTOR, it, ::serializeStreamingLoggingConfigDocument) }
        input.priceClass?.let { field(PRICECLASS_DESCRIPTOR, it.value) }
        input.s3Origin?.let { field(S3ORIGIN_DESCRIPTOR, it, ::serializeS3OriginDocument) }
        input.trustedSigners?.let { field(TRUSTEDSIGNERS_DESCRIPTOR, it, ::serializeTrustedSignersDocument) }
    }
    return serializer.toByteArray()
}
