// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.CreateStreamingDistributionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer


internal class CreateStreamingDistributionOperationDeserializer: HttpDeserialize<CreateStreamingDistributionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateStreamingDistributionResponse {
        if (!response.status.isSuccess()) {
            throwCreateStreamingDistributionError(context, response)
        }
        val builder = CreateStreamingDistributionResponse.builder()

        builder.eTag = response.headers["ETag"]
        builder.location = response.headers["Location"]

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateStreamingDistributionOperationBody(builder, payload)
        }

        return builder.build()
    }
}

private suspend fun deserializeCreateStreamingDistributionOperationBody(builder: CreateStreamingDistributionResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    builder.streamingDistribution = deserializeStreamingDistributionDocument(deserializer)
}

private suspend fun throwCreateStreamingDistributionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restXml error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer()
        "CNAMEAlreadyExists" -> CnameAlreadyExistsDeserializer()
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer()
        "InvalidArgument" -> InvalidArgumentDeserializer()
        "InvalidOrigin" -> InvalidOriginDeserializer()
        "InvalidOriginAccessIdentity" -> InvalidOriginAccessIdentityDeserializer()
        "MissingBody" -> MissingBodyDeserializer()
        "StreamingDistributionAlreadyExists" -> StreamingDistributionAlreadyExistsDeserializer()
        "TooManyStreamingDistributionCNAMEs" -> TooManyStreamingDistributionCnamEsDeserializer()
        "TooManyStreamingDistributions" -> TooManyStreamingDistributionsDeserializer()
        "TooManyTrustedSigners" -> TooManyTrustedSignersDeserializer()
        "TrustedSignerDoesNotExist" -> TrustedSignerDoesNotExistDeserializer()
        else -> throw CloudFrontException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
